/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MultisigAccountModificationTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class MultisigAccountModificationTransactionFactory
extends TransactionFactory<MultisigAccountModificationTransaction> {
    private final byte minApprovalDelta;
    private final byte minRemovalDelta;
    private final List<UnresolvedAddress> addressAdditions;
    private final List<UnresolvedAddress> addressDeletions;

    private MultisigAccountModificationTransactionFactory(NetworkType networkType, Deadline deadline, byte minApprovalDelta, byte minRemovalDelta, List<UnresolvedAddress> addressAdditions, List<UnresolvedAddress> addressDeletions) {
        super(TransactionType.MULTISIG_ACCOUNT_MODIFICATION, networkType, deadline);
        Validate.notNull(addressAdditions, (String)"AddressAdditions must not be null", (Object[])new Object[0]);
        Validate.notNull(addressDeletions, (String)"AddressDeletions must not be null", (Object[])new Object[0]);
        this.minApprovalDelta = minApprovalDelta;
        this.minRemovalDelta = minRemovalDelta;
        this.addressAdditions = addressAdditions;
        this.addressDeletions = addressDeletions;
    }

    public static MultisigAccountModificationTransactionFactory create(NetworkType networkType, Deadline deadline, byte minApprovalDelta, byte minRemovalDelta, List<UnresolvedAddress> addressAdditions, List<UnresolvedAddress> addressDeletions) {
        return new MultisigAccountModificationTransactionFactory(networkType, deadline, minApprovalDelta, minRemovalDelta, addressAdditions, addressDeletions);
    }

    public byte getMinApprovalDelta() {
        return this.minApprovalDelta;
    }

    public byte getMinRemovalDelta() {
        return this.minRemovalDelta;
    }

    public List<UnresolvedAddress> getAddressAdditions() {
        return this.addressAdditions;
    }

    public List<UnresolvedAddress> getAddressDeletions() {
        return this.addressDeletions;
    }

    @Override
    public MultisigAccountModificationTransaction build() {
        return new MultisigAccountModificationTransaction(this);
    }
}

