/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyRevocationTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import org.apache.commons.lang3.Validate;

public class MosaicSupplyRevocationTransactionFactory
extends TransactionFactory<MosaicSupplyRevocationTransaction> {
    private final UnresolvedAddress sourceAddress;
    private final Mosaic mosaic;

    private MosaicSupplyRevocationTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedAddress sourceAddress, Mosaic mosaic) {
        super(TransactionType.MOSAIC_SUPPLY_REVOCATION, networkType, deadline);
        Validate.notNull((Object)sourceAddress, (String)"Source address must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)mosaic, (String)"Mosaic must not be null", (Object[])new Object[0]);
        this.sourceAddress = sourceAddress;
        this.mosaic = mosaic;
    }

    public static MosaicSupplyRevocationTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedAddress sourceAddress, Mosaic mosaic) {
        return new MosaicSupplyRevocationTransactionFactory(networkType, deadline, sourceAddress, mosaic);
    }

    public UnresolvedAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public Mosaic getMosaic() {
        return this.mosaic;
    }

    @Override
    public MosaicSupplyRevocationTransaction build() {
        return new MosaicSupplyRevocationTransaction(this);
    }
}

