/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.mosaic.MosaicSupplyChangeActionType;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyChangeTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class MosaicSupplyChangeTransactionFactory
extends TransactionFactory<MosaicSupplyChangeTransaction> {
    private final UnresolvedMosaicId mosaicId;
    private final MosaicSupplyChangeActionType action;
    private final BigInteger delta;

    private MosaicSupplyChangeTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedMosaicId mosaicId, MosaicSupplyChangeActionType action, BigInteger delta) {
        super(TransactionType.MOSAIC_SUPPLY_CHANGE, networkType, deadline);
        Validate.notNull((Object)mosaicId, (String)"UnresolvedMosaicId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)action), (String)"Action must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)delta, (String)"Delta must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(delta);
        this.mosaicId = mosaicId;
        this.action = action;
        this.delta = delta;
    }

    public static MosaicSupplyChangeTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedMosaicId mosaicId, MosaicSupplyChangeActionType action, BigInteger delta) {
        return new MosaicSupplyChangeTransactionFactory(networkType, deadline, mosaicId, action, delta);
    }

    public UnresolvedMosaicId getMosaicId() {
        return this.mosaicId;
    }

    public MosaicSupplyChangeActionType getAction() {
        return this.action;
    }

    public BigInteger getDelta() {
        return this.delta;
    }

    @Override
    public MosaicSupplyChangeTransaction build() {
        return new MosaicSupplyChangeTransaction(this);
    }
}

