/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class MosaicMetadataTransactionFactory
extends MetadataTransactionFactory<MosaicMetadataTransaction> {
    private final UnresolvedMosaicId targetMosaicId;

    private MosaicMetadataTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedAddress targetAddress, UnresolvedMosaicId targetMosaicId, BigInteger scopedMetadataKey, byte[] value) {
        super(TransactionType.MOSAIC_METADATA, networkType, deadline, targetAddress, scopedMetadataKey, value);
        Validate.notNull((Object)targetMosaicId, (String)"TargetMosaicId must not be null", (Object[])new Object[0]);
        this.targetMosaicId = targetMosaicId;
    }

    public static MosaicMetadataTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedAddress targetAddress, UnresolvedMosaicId targetMosaicId, BigInteger scopedMetadataKey, byte[] value) {
        return new MosaicMetadataTransactionFactory(networkType, deadline, targetAddress, targetMosaicId, scopedMetadataKey, value);
    }

    public UnresolvedMosaicId getTargetMosaicId() {
        return this.targetMosaicId;
    }

    @Override
    public MosaicMetadataTransaction build() {
        return new MosaicMetadataTransaction(this);
    }
}

