/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MosaicGlobalRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicRestrictionType;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class MosaicGlobalRestrictionTransactionFactory
extends TransactionFactory<MosaicGlobalRestrictionTransaction> {
    private final UnresolvedMosaicId mosaicId;
    private final BigInteger restrictionKey;
    private final BigInteger newRestrictionValue;
    private final MosaicRestrictionType newRestrictionType;
    private BigInteger previousRestrictionValue = BigInteger.ZERO;
    private MosaicRestrictionType previousRestrictionType = MosaicRestrictionType.NONE;
    private UnresolvedMosaicId referenceMosaicId = new MosaicId(BigInteger.ZERO);

    private MosaicGlobalRestrictionTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedMosaicId mosaicId, BigInteger restrictionKey, BigInteger newRestrictionValue, MosaicRestrictionType newRestrictionType) {
        super(TransactionType.MOSAIC_GLOBAL_RESTRICTION, networkType, deadline);
        Validate.notNull((Object)mosaicId, (String)"RestrictedMosaicId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)restrictionKey, (String)"RestrictionKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)newRestrictionValue, (String)"NewRestrictionValue must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)newRestrictionType), (String)"NewRestrictionType must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(restrictionKey);
        ConvertUtils.validateNotNegative(newRestrictionValue);
        this.mosaicId = mosaicId;
        this.restrictionKey = restrictionKey;
        this.newRestrictionValue = newRestrictionValue;
        this.newRestrictionType = newRestrictionType;
    }

    public static MosaicGlobalRestrictionTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedMosaicId mosaicId, BigInteger restrictionKey, BigInteger newRestrictionValue, MosaicRestrictionType newRestrictionType) {
        return new MosaicGlobalRestrictionTransactionFactory(networkType, deadline, mosaicId, restrictionKey, newRestrictionValue, newRestrictionType);
    }

    @Override
    public MosaicGlobalRestrictionTransaction build() {
        return new MosaicGlobalRestrictionTransaction(this);
    }

    public UnresolvedMosaicId getMosaicId() {
        return this.mosaicId;
    }

    public UnresolvedMosaicId getReferenceMosaicId() {
        return this.referenceMosaicId;
    }

    public BigInteger getRestrictionKey() {
        return this.restrictionKey;
    }

    public BigInteger getPreviousRestrictionValue() {
        return this.previousRestrictionValue;
    }

    public MosaicRestrictionType getPreviousRestrictionType() {
        return this.previousRestrictionType;
    }

    public BigInteger getNewRestrictionValue() {
        return this.newRestrictionValue;
    }

    public MosaicRestrictionType getNewRestrictionType() {
        return this.newRestrictionType;
    }

    public MosaicGlobalRestrictionTransactionFactory referenceMosaicId(UnresolvedMosaicId referenceMosaicId) {
        Validate.notNull((Object)referenceMosaicId, (String)"ReferenceMosaicId must not be null", (Object[])new Object[0]);
        this.referenceMosaicId = referenceMosaicId;
        return this;
    }

    public MosaicGlobalRestrictionTransactionFactory previousRestrictionType(MosaicRestrictionType previousRestrictionType) {
        Validate.notNull((Object)((Object)previousRestrictionType), (String)"PreviousRestrictionType must not be null", (Object[])new Object[0]);
        this.previousRestrictionType = previousRestrictionType;
        return this;
    }

    public MosaicGlobalRestrictionTransactionFactory previousRestrictionValue(BigInteger previousRestrictionValue) {
        Validate.notNull((Object)previousRestrictionValue, (String)"PreviousRestrictionValue must not be null", (Object[])new Object[0]);
        this.previousRestrictionValue = previousRestrictionValue;
        return this;
    }
}

