/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.blockchain.BlockDuration;
import io.nem.symbol.sdk.model.mosaic.MosaicFlags;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicNonce;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MosaicDefinitionTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import org.apache.commons.lang3.Validate;

public class MosaicDefinitionTransactionFactory
extends TransactionFactory<MosaicDefinitionTransaction> {
    private final MosaicNonce mosaicNonce;
    private final MosaicId mosaicId;
    private final MosaicFlags mosaicFlags;
    private final int divisibility;
    private final BlockDuration blockDuration;

    private MosaicDefinitionTransactionFactory(NetworkType networkType, Deadline deadline, MosaicNonce mosaicNonce, MosaicId mosaicId, MosaicFlags mosaicFlags, int divisibility, BlockDuration blockDuration) {
        super(TransactionType.MOSAIC_DEFINITION, networkType, deadline);
        Validate.notNull((Object)mosaicNonce, (String)"MosaicNonce must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)mosaicId, (String)"MosaicId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)mosaicFlags, (String)"MosaicFlags must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)blockDuration, (String)"BlockDuration must not be null", (Object[])new Object[0]);
        this.mosaicNonce = mosaicNonce;
        this.mosaicId = mosaicId;
        this.mosaicFlags = mosaicFlags;
        this.divisibility = divisibility;
        this.blockDuration = blockDuration;
    }

    public static MosaicDefinitionTransactionFactory create(NetworkType networkType, Deadline deadline, MosaicNonce mosaicNonce, MosaicId mosaicId, MosaicFlags mosaicFlags, int divisibility, BlockDuration blockDuration) {
        return new MosaicDefinitionTransactionFactory(networkType, deadline, mosaicNonce, mosaicId, mosaicFlags, divisibility, blockDuration);
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public MosaicNonce getMosaicNonce() {
        return this.mosaicNonce;
    }

    public MosaicFlags getMosaicFlags() {
        return this.mosaicFlags;
    }

    public BlockDuration getBlockDuration() {
        return this.blockDuration;
    }

    public int getDivisibility() {
        return this.divisibility;
    }

    @Override
    public MosaicDefinitionTransaction build() {
        return new MosaicDefinitionTransaction(this);
    }
}

