/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MosaicAddressRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.TargetAddressTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class MosaicAddressRestrictionTransactionFactory
extends TransactionFactory<MosaicAddressRestrictionTransaction>
implements TargetAddressTransaction {
    private final UnresolvedMosaicId mosaicId;
    private final BigInteger restrictionKey;
    private final UnresolvedAddress targetAddress;
    private BigInteger previousRestrictionValue = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private final BigInteger newRestrictionValue;

    private MosaicAddressRestrictionTransactionFactory(NetworkType networkType, Deadline deadline, UnresolvedMosaicId mosaicId, BigInteger restrictionKey, UnresolvedAddress targetAddress, BigInteger newRestrictionValue) {
        super(TransactionType.MOSAIC_ADDRESS_RESTRICTION, networkType, deadline);
        Validate.notNull((Object)mosaicId, (String)"UnresolvedMosaicId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)restrictionKey, (String)"RestrictionKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)targetAddress, (String)"TargetAddress must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)newRestrictionValue, (String)"NewRestrictionValue must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(restrictionKey);
        ConvertUtils.validateNotNegative(newRestrictionValue);
        this.mosaicId = mosaicId;
        this.restrictionKey = restrictionKey;
        this.targetAddress = targetAddress;
        this.newRestrictionValue = newRestrictionValue;
    }

    public static MosaicAddressRestrictionTransactionFactory create(NetworkType networkType, Deadline deadline, UnresolvedMosaicId mosaicId, BigInteger restrictionKey, UnresolvedAddress targetAddress, BigInteger newRestrictionValue) {
        return new MosaicAddressRestrictionTransactionFactory(networkType, deadline, mosaicId, restrictionKey, targetAddress, newRestrictionValue);
    }

    @Override
    public MosaicAddressRestrictionTransaction build() {
        return new MosaicAddressRestrictionTransaction(this);
    }

    public UnresolvedMosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getRestrictionKey() {
        return this.restrictionKey;
    }

    @Override
    public UnresolvedAddress getTargetAddress() {
        return this.targetAddress;
    }

    public BigInteger getPreviousRestrictionValue() {
        return this.previousRestrictionValue;
    }

    public MosaicAddressRestrictionTransactionFactory previousRestrictionValue(BigInteger previousRestrictionValue) {
        this.previousRestrictionValue = previousRestrictionValue;
        Validate.notNull((Object)previousRestrictionValue, (String)"PreviousRestrictionValue must not be null", (Object[])new Object[0]);
        return this;
    }

    public BigInteger getNewRestrictionValue() {
        return this.newRestrictionValue;
    }
}

