/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MetadataTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public abstract class MetadataTransactionFactory<T extends MetadataTransaction>
extends TransactionFactory<T> {
    private final UnresolvedAddress targetAddress;
    private final BigInteger scopedMetadataKey;
    private final byte[] value;
    private int valueSizeDelta;
    private long valueSize;

    MetadataTransactionFactory(TransactionType transactionType, NetworkType networkType, Deadline deadline, UnresolvedAddress targetAddress, BigInteger scopedMetadataKey, byte[] value) {
        super(transactionType, networkType, deadline);
        int defaultSize;
        Validate.notNull((Object)targetAddress, (String)"TargetAddress must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)scopedMetadataKey, (String)"ScopedMetadataKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"Value must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(scopedMetadataKey);
        this.targetAddress = targetAddress;
        this.scopedMetadataKey = scopedMetadataKey;
        this.value = value;
        this.valueSizeDelta = defaultSize = value.length;
        this.valueSize = defaultSize;
    }

    public UnresolvedAddress getTargetAddress() {
        return this.targetAddress;
    }

    public BigInteger getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public int getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public MetadataTransactionFactory<T> valueSizeDelta(int valueSizeDelta) {
        this.valueSizeDelta = valueSizeDelta;
        return this;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public MetadataTransactionFactory<T> valueSize(long valueSize) {
        this.valueSize = valueSize;
        return this;
    }

    public byte[] getValue() {
        return this.value;
    }
}

