/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.StringEncoder;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.transaction.MetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.Transaction;
import java.math.BigInteger;

public abstract class MetadataTransaction
extends Transaction {
    private final UnresolvedAddress targetAddress;
    private final BigInteger scopedMetadataKey;
    private final int valueSizeDelta;
    private final long valueSize;
    private final byte[] value;

    MetadataTransaction(MetadataTransactionFactory<?> factory) {
        super(factory);
        this.targetAddress = factory.getTargetAddress();
        this.scopedMetadataKey = factory.getScopedMetadataKey();
        this.valueSizeDelta = factory.getValueSizeDelta();
        this.value = factory.getValue();
        this.valueSize = factory.getValueSize();
    }

    public UnresolvedAddress getTargetAddress() {
        return this.targetAddress;
    }

    public BigInteger getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public int getValueSizeDelta() {
        return this.valueSizeDelta;
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getValueSize() {
        return this.valueSize;
    }

    public static byte[] toByteArray(String value) {
        return StringEncoder.getBytes(value);
    }
}

