/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.Hasher;
import io.nem.symbol.core.crypto.Hashes;
import java.util.Arrays;

public enum LockHashAlgorithm implements Hasher
{
    SHA3_256(0, Hashes::sha3_256),
    HASH_160(1, Hashes::hash160),
    HASH_256(2, Hashes::hash256);

    public static final String VALIDATOR_REGEX = "-?[0-9a-fA-F]+";
    public static final int DEFAULT_SECRET_BYTE_ARRAY_SIZE = 32;
    public static final int DEFAULT_SECRET_HEX_SIZE = 64;
    private final int value;
    private final Hasher delegate;

    private LockHashAlgorithm(int value, Hasher delegate) {
        this.value = value;
        this.delegate = delegate;
    }

    public static LockHashAlgorithm rawValueOf(int value) {
        return Arrays.stream(LockHashAlgorithm.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " is not a valid value"));
    }

    public static boolean validator(LockHashAlgorithm hashType, String input) {
        if (!input.matches(VALIDATOR_REGEX)) {
            return false;
        }
        if (hashType == HASH_160) {
            return input.length() == 64 || input.length() == 40;
        }
        return input.length() == 64;
    }

    @Override
    public byte[] hash(byte[] ... values) {
        return this.delegate.hash(values);
    }

    public int getValue() {
        return this.value;
    }
}

