/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.mosaic.IllegalIdentifierException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class IdGenerator {
    private static final long ID_GENERATOR_FLAG = Long.MIN_VALUE;

    private IdGenerator() {
    }

    public static BigInteger generateMosaicId(int nonce, byte[] publicKey) {
        ByteBuffer parentIdBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(nonce);
        byte[] hash = IdGenerator.getHashInLittleEndian(parentIdBuffer.array(), publicKey);
        return BigInteger.valueOf(ByteBuffer.wrap(hash).getLong() & Long.MAX_VALUE);
    }

    public static BigInteger generateNamespaceId(String namespaceName, BigInteger parentId) {
        if (!namespaceName.matches("^[a-z0-9][a-z0-9-_]*$")) {
            throw new IllegalIdentifierException("invalid namespace name");
        }
        ByteBuffer parentIdBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(parentId.longValue());
        byte[] hash = IdGenerator.getHashInLittleEndian(parentIdBuffer.array(), namespaceName.getBytes());
        return ConvertUtils.toUnsignedBigInteger(ByteBuffer.wrap(hash).getLong() | Long.MIN_VALUE);
    }

    public static BigInteger generateNamespaceId(String namespaceName, String parentNamespaceName) {
        return IdGenerator.generateNamespaceId(parentNamespaceName + "." + namespaceName);
    }

    public static BigInteger generateNamespaceId(String namespacePath) {
        List<BigInteger> namespaceList = IdGenerator.generateNamespacePath(namespacePath);
        return namespaceList.get(namespaceList.size() - 1);
    }

    public static List<BigInteger> generateNamespacePath(String namespacePath) {
        String[] parts = namespacePath.split(Pattern.quote("."));
        ArrayList<BigInteger> path = new ArrayList<BigInteger>();
        if (parts.length == 0) {
            throw new IllegalIdentifierException("invalid namespace path");
        }
        BigInteger namespaceId = BigInteger.valueOf(0L);
        for (String part : parts) {
            namespaceId = IdGenerator.generateNamespaceId(part, namespaceId);
            path.add(namespaceId);
        }
        return path;
    }

    private static byte[] getHashInLittleEndian(byte[] ... inputs) {
        byte[] result = Hashes.sha3_256(inputs);
        result = Arrays.copyOfRange(result, 0, 8);
        ArrayUtils.reverse((byte[])result);
        return result;
    }
}

