/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.HashLockTransaction;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class HashLockTransactionFactory
extends TransactionFactory<HashLockTransaction> {
    private final Mosaic mosaic;
    private final BigInteger duration;
    private final String hash;

    private HashLockTransactionFactory(NetworkType networkType, Deadline deadline, Mosaic mosaic, BigInteger duration, String hash) {
        super(TransactionType.HASH_LOCK, networkType, deadline);
        Validate.notNull((Object)mosaic, (String)"Mosaic must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)duration, (String)"Duration must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)hash, (String)"Hash must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(duration);
        this.mosaic = mosaic;
        this.duration = duration;
        this.hash = hash;
    }

    public static HashLockTransactionFactory create(NetworkType networkType, Deadline deadline, Mosaic mosaic, BigInteger duration, String hash) {
        return new HashLockTransactionFactory(networkType, deadline, mosaic, duration, hash);
    }

    public static HashLockTransactionFactory create(NetworkType networkType, Deadline deadline, Mosaic mosaic, BigInteger duration, SignedTransaction signedTransaction) {
        if (signedTransaction.getType() != TransactionType.AGGREGATE_BONDED) {
            throw new IllegalArgumentException("Signed transaction must be Aggregate Bonded Transaction");
        }
        return new HashLockTransactionFactory(networkType, deadline, mosaic, duration, signedTransaction.getHash());
    }

    public Mosaic getMosaic() {
        return this.mosaic;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public String getHash() {
        return this.hash;
    }

    @Override
    public HashLockTransaction build() {
        return new HashLockTransaction(this);
    }
}

