/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HashLockInfoBuilder;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.LockStatusDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.transaction.LockStatus;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class HashLockInfo
implements Stored {
    private final String recordId;
    private final int version;
    private final Address ownerAddress;
    private final MosaicId mosaicId;
    private final BigInteger amount;
    private final BigInteger endHeight;
    private final LockStatus status;
    private final String hash;

    public HashLockInfo(String recordId, int version, Address ownerAddress, MosaicId mosaicId, BigInteger amount, BigInteger endHeight, LockStatus status, String hash) {
        this.version = version;
        Validate.notNull((Object)ownerAddress, (String)"ownerAddress is required", (Object[])new Object[0]);
        Validate.notNull((Object)mosaicId, (String)"mosaicId is required", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"amount is required", (Object[])new Object[0]);
        Validate.notNull((Object)endHeight, (String)"endHeight is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)status), (String)"status is required", (Object[])new Object[0]);
        Validate.notNull((Object)hash, (String)"hash is required", (Object[])new Object[0]);
        this.recordId = recordId;
        this.ownerAddress = ownerAddress;
        this.mosaicId = mosaicId;
        this.amount = amount;
        this.endHeight = endHeight;
        this.status = status;
        this.hash = hash;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public BigInteger getEndHeight() {
        return this.endHeight;
    }

    public LockStatus getStatus() {
        return this.status;
    }

    public String getHash() {
        return this.hash;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] serialize() {
        AddressDto ownerAddress = SerializationUtils.toAddressDto(this.getOwnerAddress());
        MosaicBuilder mosaic = MosaicBuilder.create((MosaicIdDto)SerializationUtils.toMosaicIdDto(this.getMosaicId()), (AmountDto)SerializationUtils.toAmount(this.getAmount()));
        HeightDto endHeight = new HeightDto(this.getEndHeight().longValue());
        LockStatusDto status = LockStatusDto.rawValueOf((byte)this.getStatus().getValue());
        Hash256Dto hash = SerializationUtils.toHash256Dto(this.getHash());
        return HashLockInfoBuilder.create((short)((short)this.getVersion()), (AddressDto)ownerAddress, (MosaicBuilder)mosaic, (HeightDto)endHeight, (LockStatusDto)status, (Hash256Dto)hash).serialize();
    }
}

