/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;

public class Deadline {
    private final BigInteger value;

    public Deadline(BigInteger input) {
        this.value = input;
    }

    public static Deadline create(Duration epochAdjustment, int units, ChronoUnit chronoUnit) {
        long millis = Instant.now().plus((long)units, chronoUnit).minus(epochAdjustment).toEpochMilli();
        return new Deadline(BigInteger.valueOf(millis));
    }

    public static Deadline create(Duration epochAdjustment) {
        return Deadline.create(epochAdjustment, 2, ChronoUnit.HOURS);
    }

    public BigInteger toBigInteger() {
        return this.value;
    }

    public long getValue() {
        return this.value.longValue();
    }

    public Instant getInstant(Duration epochAdjustment) {
        return Instant.ofEpochMilli(this.value.longValue()).plusMillis(epochAdjustment.toMillis());
    }

    public LocalDateTime getLocalDateTime(Duration epochAdjustment, ZoneId zoneId) {
        return LocalDateTime.ofInstant(this.getInstant(epochAdjustment), zoneId);
    }

    public LocalDateTime getLocalDateTime(Duration epochAdjustment) {
        return this.getLocalDateTime(epochAdjustment, ZoneId.systemDefault());
    }
}

