/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.Account;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.TransactionInfo;

public class CosignatureTransaction {
    private final AggregateTransaction transactionToCosign;
    private final String transactionHash;

    public CosignatureTransaction(AggregateTransaction transactionToCosign) {
        this.transactionToCosign = transactionToCosign;
        this.transactionHash = (String)transactionToCosign.getTransactionInfo().flatMap(TransactionInfo::getHash).orElseThrow(() -> new IllegalArgumentException("Transaction to cosign should be announced before being able to cosign it"));
    }

    public static CosignatureTransaction create(AggregateTransaction transactionToCosign) {
        return new CosignatureTransaction(transactionToCosign);
    }

    public AggregateTransaction getTransactionToCosign() {
        return this.transactionToCosign;
    }

    public CosignatureSignedTransaction signWith(Account account) {
        return account.signCosignatureTransaction(this.transactionHash);
    }
}

