/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.Hasher;
import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.crypto.MerkleHashBuilder;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.infrastructure.BinarySerializationImpl;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class AggregateTransactionFactory
extends TransactionFactory<AggregateTransaction> {
    public static final int COSIGNATURE_SIZE = 104;
    private final String transactionsHash;
    private final List<Transaction> innerTransactions;
    private final List<AggregateTransactionCosignature> cosignatures;

    private AggregateTransactionFactory(TransactionType type, Deadline deadline, NetworkType networkType, String transactionsHash, List<Transaction> innerTransactions, List<AggregateTransactionCosignature> cosignatures) {
        super(type, networkType, deadline);
        String theTransactionsHash = transactionsHash == null ? AggregateTransactionFactory.calculateTransactionsHash(innerTransactions) : transactionsHash;
        Validate.notNull((Object)theTransactionsHash, (String)"transactionsHash must not be null", (Object[])new Object[0]);
        Validate.notNull(innerTransactions, (String)"InnerTransactions must not be null", (Object[])new Object[0]);
        Validate.notNull(cosignatures, (String)"Cosignatures must not be null", (Object[])new Object[0]);
        ConvertUtils.validateIsHexString(theTransactionsHash, 64);
        this.transactionsHash = theTransactionsHash;
        this.innerTransactions = Collections.unmodifiableList(innerTransactions);
        this.cosignatures = new ArrayList<AggregateTransactionCosignature>(cosignatures);
    }

    public static AggregateTransactionFactory create(TransactionType type, NetworkType networkType, Deadline deadline, String transactionsHash, List<Transaction> innerTransactions, List<AggregateTransactionCosignature> cosignatures) {
        return new AggregateTransactionFactory(type, deadline, networkType, transactionsHash, innerTransactions, cosignatures);
    }

    public static AggregateTransactionFactory create(TransactionType type, NetworkType networkType, Deadline deadline, List<Transaction> innerTransactions, List<AggregateTransactionCosignature> cosignatures) {
        return AggregateTransactionFactory.create(type, networkType, deadline, AggregateTransactionFactory.calculateTransactionsHash(innerTransactions), innerTransactions, cosignatures);
    }

    public static AggregateTransactionFactory createComplete(NetworkType networkType, Deadline deadline, List<Transaction> innerTransactions) {
        return AggregateTransactionFactory.create(TransactionType.AGGREGATE_COMPLETE, networkType, deadline, innerTransactions, new ArrayList<AggregateTransactionCosignature>());
    }

    public static AggregateTransactionFactory createBonded(NetworkType networkType, Deadline deadline, List<Transaction> innerTransactions) {
        return AggregateTransactionFactory.create(TransactionType.AGGREGATE_BONDED, networkType, deadline, innerTransactions, new ArrayList<AggregateTransactionCosignature>());
    }

    private static String calculateTransactionsHash(List<Transaction> transactions) {
        MerkleHashBuilder transactionsHashBuilder = new MerkleHashBuilder();
        BinarySerializationImpl transactionSerialization = new BinarySerializationImpl();
        Hasher hasher = Hashes::sha3_256;
        for (Transaction transaction : transactions) {
            byte[] bytes = transactionSerialization.serializeEmbedded(transaction);
            byte[] transactionHash = hasher.hash(new byte[][]{bytes});
            transactionsHashBuilder.update(transactionHash);
        }
        byte[] hash = transactionsHashBuilder.getRootHash();
        return ConvertUtils.toHex(hash);
    }

    public AggregateTransactionFactory calculateMaxFeeFromMultiplier(long feeMultiplier) {
        throw new IllegalArgumentException("calculateMaxFeeFromMultiplier can only be used for non-aggregate transactions.");
    }

    public AggregateTransactionFactory calculateMaxFeeForAggregate(long feeMultiplier, int requiredCosignatures) {
        int calculatedCosignatures = Math.max(this.cosignatures.size(), requiredCosignatures);
        long calculatedSize = this.getSize() + (long)((calculatedCosignatures - this.cosignatures.size()) * 104);
        return (AggregateTransactionFactory)this.maxFee(BigInteger.valueOf(calculatedSize).multiply(BigInteger.valueOf(feeMultiplier)));
    }

    public List<Transaction> getInnerTransactions() {
        return this.innerTransactions;
    }

    public List<AggregateTransactionCosignature> getCosignatures() {
        return this.cosignatures;
    }

    public AggregateTransactionFactory addCosignatures(AggregateTransactionCosignature ... newCosignatures) {
        Validate.notNull((Object)newCosignatures, (String)"newCosignatures is required", (Object[])new Object[0]);
        this.cosignatures.addAll(Arrays.asList(newCosignatures));
        return this;
    }

    public String getTransactionsHash() {
        return this.transactionsHash;
    }

    @Override
    public AggregateTransaction build() {
        return new AggregateTransaction(this);
    }
}

