/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.catapult.builders.CosignatureBuilder;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.Account;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionFactory;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class AggregateTransaction
extends Transaction {
    private final String transactionsHash;
    private final List<Transaction> innerTransactions;
    private final List<AggregateTransactionCosignature> cosignatures;

    AggregateTransaction(AggregateTransactionFactory factory) {
        super(factory);
        this.transactionsHash = factory.getTransactionsHash();
        this.innerTransactions = Collections.unmodifiableList(factory.getInnerTransactions());
        this.cosignatures = Collections.unmodifiableList(factory.getCosignatures());
    }

    public List<Transaction> getInnerTransactions() {
        return this.innerTransactions;
    }

    public List<AggregateTransactionCosignature> getCosignatures() {
        return this.cosignatures;
    }

    public String getTransactionsHash() {
        return this.transactionsHash;
    }

    public SignedTransaction signTransactionWithCosigners(Account initiatorAccount, List<Account> cosignatories, String generationHash) {
        SignedTransaction signedTransaction = this.signWith(initiatorAccount, generationHash);
        List cosignatures = cosignatories.stream().map(cosignatory -> cosignatory.signCosignatureTransaction(signedTransaction.getHash())).collect(Collectors.toList());
        return this.signTransactionGivenSignatures(initiatorAccount, cosignatures, generationHash);
    }

    public SignedTransaction signTransactionGivenSignatures(Account initiatorAccount, List<? extends AggregateTransactionCosignature> cosignatures, String generationHash) {
        SignedTransaction signedTransaction = this.signWith(initiatorAccount, generationHash);
        StringBuilder payload = new StringBuilder(signedTransaction.getPayload());
        for (AggregateTransactionCosignature aggregateTransactionCosignature : cosignatures) {
            SignatureDto signature = SerializationUtils.toSignatureDto(aggregateTransactionCosignature.getSignature());
            CosignatureBuilder builder = CosignatureBuilder.create((long)aggregateTransactionCosignature.getVersion().longValue(), (KeyDto)SerializationUtils.toKeyDto(aggregateTransactionCosignature.getSigner().getPublicKey()), (SignatureDto)signature);
            payload.append(ConvertUtils.toHex(builder.serialize()));
        }
        byte[] payloadBytes = ConvertUtils.fromHexToBytes(payload.toString());
        byte[] byArray = BigInteger.valueOf(payloadBytes.length).toByteArray();
        ArrayUtils.reverse((byte[])byArray);
        System.arraycopy(byArray, 0, payloadBytes, 0, byArray.length);
        return new SignedTransaction(initiatorAccount.getPublicAccount(), ConvertUtils.toHex(payloadBytes), signedTransaction.getHash(), this.getType());
    }

    @Override
    public byte[] getSignBytes(byte[] payloadBytes, byte[] generationHashBytes) {
        int headerSize = 108;
        int signingBytesSize = 52;
        byte[] signingBytes = new byte[52 + generationHashBytes.length];
        System.arraycopy(generationHashBytes, 0, signingBytes, 0, generationHashBytes.length);
        System.arraycopy(payloadBytes, 108, signingBytes, generationHashBytes.length, 52);
        return signingBytes;
    }

    public boolean signedByAccount(PublicAccount publicAccount) {
        return this.getSigner().filter(a -> a.equals(publicAccount)).isPresent() || this.getCosignatures().stream().anyMatch(o -> o.getSigner().equals(publicAccount));
    }

    @Override
    public boolean isTransactionFullyLoaded() {
        return !this.innerTransactions.isEmpty();
    }
}

