/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.namespace.AliasAction;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AddressAliasTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import org.apache.commons.lang3.Validate;

public class AddressAliasTransactionFactory
extends TransactionFactory<AddressAliasTransaction> {
    private final AliasAction aliasAction;
    private final NamespaceId namespaceId;
    private final Address address;

    private AddressAliasTransactionFactory(NetworkType networkType, Deadline deadline, AliasAction aliasAction, NamespaceId namespaceId, Address address) {
        super(TransactionType.ADDRESS_ALIAS, networkType, deadline);
        Validate.notNull((Object)((Object)aliasAction), (String)"aliasAction must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)namespaceId, (String)"namespaceId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)address, (String)"address must not be null", (Object[])new Object[0]);
        this.aliasAction = aliasAction;
        this.namespaceId = namespaceId;
        this.address = address;
    }

    public static AddressAliasTransactionFactory create(NetworkType networkType, Deadline deadline, AliasAction aliasAction, NamespaceId namespaceId, Address address) {
        return new AddressAliasTransactionFactory(networkType, deadline, aliasAction, namespaceId, address);
    }

    public AliasAction getAliasAction() {
        return this.aliasAction;
    }

    public NamespaceId getNamespaceId() {
        return this.namespaceId;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public AddressAliasTransaction build() {
        return new AddressAliasTransaction(this);
    }
}

