/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountOperationRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountOperationRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class AccountOperationRestrictionTransactionFactory
extends TransactionFactory<AccountOperationRestrictionTransaction> {
    private final AccountOperationRestrictionFlags restrictionFlags;
    private final List<TransactionType> restrictionAdditions;
    private final List<TransactionType> restrictionDeletions;

    private AccountOperationRestrictionTransactionFactory(NetworkType networkType, Deadline deadline, AccountOperationRestrictionFlags restrictionFlags, List<TransactionType> restrictionAdditions, List<TransactionType> restrictionDeletions) {
        super(TransactionType.ACCOUNT_OPERATION_RESTRICTION, networkType, deadline);
        Validate.notNull((Object)restrictionFlags, (String)"RestrictionType must not be null", (Object[])new Object[0]);
        Validate.notNull(restrictionAdditions, (String)"RestrictionAdditions must not be null", (Object[])new Object[0]);
        Validate.notNull(restrictionDeletions, (String)"RestrictionDeletions must not be null", (Object[])new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountOperationRestrictionTransactionFactory create(NetworkType networkType, Deadline deadline, AccountOperationRestrictionFlags restrictionFlags, List<TransactionType> restrictionAdditions, List<TransactionType> restrictionDeletions) {
        return new AccountOperationRestrictionTransactionFactory(networkType, deadline, restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public AccountOperationRestrictionFlags getRestrictionFlags() {
        return this.restrictionFlags;
    }

    @Override
    public AccountOperationRestrictionTransaction build() {
        return new AccountOperationRestrictionTransaction(this);
    }

    public List<TransactionType> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<TransactionType> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }
}

