/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class AccountMosaicRestrictionTransactionFactory
extends TransactionFactory<AccountMosaicRestrictionTransaction> {
    private final AccountMosaicRestrictionFlags restrictionFlags;
    private final List<UnresolvedMosaicId> restrictionAdditions;
    private final List<UnresolvedMosaicId> restrictionDeletions;

    private AccountMosaicRestrictionTransactionFactory(NetworkType networkType, Deadline deadline, AccountMosaicRestrictionFlags restrictionFlags, List<UnresolvedMosaicId> restrictionAdditions, List<UnresolvedMosaicId> restrictionDeletions) {
        super(TransactionType.ACCOUNT_MOSAIC_RESTRICTION, networkType, deadline);
        Validate.notNull((Object)restrictionFlags, (String)"RestrictionType must not be null", (Object[])new Object[0]);
        Validate.notNull(restrictionAdditions, (String)"RestrictionAdditions must not be null", (Object[])new Object[0]);
        Validate.notNull(restrictionDeletions, (String)"RestrictionDeletions must not be null", (Object[])new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountMosaicRestrictionTransactionFactory create(NetworkType networkType, Deadline deadline, AccountMosaicRestrictionFlags restrictionFlags, List<UnresolvedMosaicId> restrictionAdditions, List<UnresolvedMosaicId> restrictionDeletions) {
        return new AccountMosaicRestrictionTransactionFactory(networkType, deadline, restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public AccountMosaicRestrictionFlags getRestrictionFlags() {
        return this.restrictionFlags;
    }

    @Override
    public AccountMosaicRestrictionTransaction build() {
        return new AccountMosaicRestrictionTransaction(this);
    }

    public List<UnresolvedMosaicId> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<UnresolvedMosaicId> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }
}

