/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.transaction.AccountRestrictionFlag;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionTargetType;
import java.util.Arrays;
import java.util.List;

public enum AccountMosaicRestrictionFlags implements AccountRestrictionFlags
{
    ALLOW_INCOMING_MOSAIC(AccountRestrictionFlag.MOSAIC_VALUE),
    BLOCK_MOSAIC(AccountRestrictionFlag.MOSAIC_VALUE, AccountRestrictionFlag.BLOCK_VALUE);

    private final List<AccountRestrictionFlag> flags;
    private final int value;

    private AccountMosaicRestrictionFlags(AccountRestrictionFlag ... flags) {
        this.flags = Arrays.asList(flags);
        this.value = this.flags.stream().mapToInt(AccountRestrictionFlag::getValue).sum();
    }

    public static AccountMosaicRestrictionFlags rawValueOf(int value) {
        return Arrays.stream(AccountMosaicRestrictionFlags.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " is not a valid value"));
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public List<AccountRestrictionFlag> getFlags() {
        return this.flags;
    }

    @Override
    public AccountRestrictionTargetType getTargetType() {
        return AccountRestrictionTargetType.MOSAIC_ID;
    }
}

