/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountKeyLinkTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.LinkAction;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import org.apache.commons.lang3.Validate;

public class AccountKeyLinkTransactionFactory
extends TransactionFactory<AccountKeyLinkTransaction> {
    private final PublicKey linkedPublicKey;
    private final LinkAction linkAction;

    private AccountKeyLinkTransactionFactory(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, LinkAction linkAction) {
        super(TransactionType.ACCOUNT_KEY_LINK, networkType, deadline);
        Validate.notNull((Object)linkedPublicKey, (String)"LinkedPublicKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)linkAction), (String)"LinkAction must not be null", (Object[])new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static AccountKeyLinkTransactionFactory create(NetworkType networkType, Deadline deadline, PublicKey linkedPublicKey, LinkAction linkAction) {
        return new AccountKeyLinkTransactionFactory(networkType, deadline, linkedPublicKey, linkAction);
    }

    public PublicKey getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkAction getLinkAction() {
        return this.linkAction;
    }

    @Override
    public AccountKeyLinkTransaction build() {
        return new AccountKeyLinkTransaction(this);
    }
}

