/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class AccountAddressRestrictionTransactionFactory
extends TransactionFactory<AccountAddressRestrictionTransaction> {
    private final AccountAddressRestrictionFlags restrictionFlags;
    private final List<UnresolvedAddress> restrictionAdditions;
    private final List<UnresolvedAddress> restrictionDeletions;

    private AccountAddressRestrictionTransactionFactory(NetworkType networkType, Deadline deadline, AccountAddressRestrictionFlags restrictionFlags, List<UnresolvedAddress> restrictionAdditions, List<UnresolvedAddress> restrictionDeletions) {
        super(TransactionType.ACCOUNT_ADDRESS_RESTRICTION, networkType, deadline);
        Validate.notNull((Object)restrictionFlags, (String)"RestrictionType must not be null", (Object[])new Object[0]);
        Validate.notNull(restrictionAdditions, (String)"RestrictionAdditions must not be null", (Object[])new Object[0]);
        Validate.notNull(restrictionDeletions, (String)"RestrictionDeletions must not be null", (Object[])new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountAddressRestrictionTransactionFactory create(NetworkType networkType, Deadline deadline, AccountAddressRestrictionFlags restrictionFlags, List<UnresolvedAddress> restrictionAdditions, List<UnresolvedAddress> restrictionDeletions) {
        return new AccountAddressRestrictionTransactionFactory(networkType, deadline, restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public AccountAddressRestrictionFlags getRestrictionFlags() {
        return this.restrictionFlags;
    }

    @Override
    public AccountAddressRestrictionTransaction build() {
        return new AccountAddressRestrictionTransaction(this);
    }

    public List<UnresolvedAddress> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<UnresolvedAddress> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }
}

