/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.transaction;

import io.nem.symbol.sdk.model.transaction.AccountRestrictionFlag;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionFlags;
import io.nem.symbol.sdk.model.transaction.AccountRestrictionTargetType;
import java.util.Arrays;
import java.util.List;

public enum AccountAddressRestrictionFlags implements AccountRestrictionFlags
{
    ALLOW_INCOMING_ADDRESS(AccountRestrictionFlag.ADDRESS_VALUE),
    ALLOW_OUTGOING_ADDRESS(AccountRestrictionFlag.ADDRESS_VALUE, AccountRestrictionFlag.OUTGOING_VALUE),
    BLOCK_ADDRESS(AccountRestrictionFlag.ADDRESS_VALUE, AccountRestrictionFlag.BLOCK_VALUE),
    BLOCK_OUTGOING_ADDRESS(AccountRestrictionFlag.ADDRESS_VALUE, AccountRestrictionFlag.BLOCK_VALUE, AccountRestrictionFlag.OUTGOING_VALUE);

    private final List<AccountRestrictionFlag> flags;
    private final int value;

    private AccountAddressRestrictionFlags(AccountRestrictionFlag ... flags) {
        this.flags = Arrays.asList(flags);
        this.value = this.flags.stream().mapToInt(AccountRestrictionFlag::getValue).sum();
    }

    public static AccountAddressRestrictionFlags rawValueOf(int value) {
        return Arrays.stream(AccountAddressRestrictionFlags.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " is not a valid value"));
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public List<AccountRestrictionFlag> getFlags() {
        return this.flags;
    }

    @Override
    public AccountRestrictionTargetType getTargetType() {
        return AccountRestrictionTargetType.ADDRESS;
    }
}

