/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.state;

import io.nem.symbol.sdk.model.state.MerkleTree;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StateMerkleProof<S> {
    private final S state;
    private final String stateHash;
    private final MerkleTree merkleTree;
    private final String raw;

    public StateMerkleProof(S state, String stateHash, MerkleTree merkleTree, String raw) {
        this.state = state;
        this.stateHash = stateHash;
        this.merkleTree = merkleTree;
        this.raw = raw;
    }

    public String getStateHash() {
        return this.stateHash;
    }

    public MerkleTree getMerkleTree() {
        return this.merkleTree;
    }

    public boolean isValid() {
        return this.getLeafValue().map(leafValue -> StringUtils.equalsAnyIgnoreCase((CharSequence)this.stateHash, (CharSequence[])new CharSequence[]{leafValue})).orElse(false);
    }

    public Optional<String> getRootHash() {
        MerkleTree tree = this.getMerkleTree();
        if (!tree.getBranches().isEmpty()) {
            return Optional.of(tree.getBranches().get(0).getBranchHash());
        }
        if (tree.getLeaf() != null) {
            return Optional.ofNullable(tree.getLeaf().getLeafHash());
        }
        return Optional.empty();
    }

    public Optional<String> getLeafValue() {
        MerkleTree tree = this.getMerkleTree();
        if (tree.getLeaf() != null) {
            return Optional.ofNullable(tree.getLeaf().getValue());
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMerkleProof that = (StateMerkleProof)o;
        return Objects.equals(this.state, that.state) && Objects.equals(this.stateHash, that.stateHash) && Objects.equals(this.merkleTree, that.merkleTree) && Objects.equals(this.raw, that.raw);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.stateHash, this.merkleTree, this.raw);
    }

    public String getRaw() {
        return this.raw;
    }

    public S getState() {
        return this.state;
    }
}

