/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.restriction;

import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.restriction.MosaicRestrictionEntryType;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;

public abstract class MosaicRestriction<T>
implements Stored {
    private final String recordId;
    private final int version;
    public final String compositeHash;
    public final MosaicRestrictionEntryType entryType;
    private final MosaicId mosaicId;
    private final Map<BigInteger, T> restrictions;

    protected MosaicRestriction(String recordId, int version, String compositeHash, MosaicRestrictionEntryType entryType, MosaicId mosaicId, Map<BigInteger, T> restrictions) {
        this.recordId = recordId;
        this.version = version;
        this.compositeHash = compositeHash;
        this.entryType = entryType;
        this.mosaicId = mosaicId;
        this.restrictions = restrictions;
    }

    public String getCompositeHash() {
        return this.compositeHash;
    }

    public MosaicRestrictionEntryType getEntryType() {
        return this.entryType;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public Map<BigInteger, T> getRestrictions() {
        return this.restrictions;
    }

    public abstract byte[] serialize();

    public int getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }
}

