/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.restriction;

import io.nem.symbol.catapult.builders.GlobalKeyValueBuilder;
import io.nem.symbol.catapult.builders.GlobalKeyValueSetBuilder;
import io.nem.symbol.catapult.builders.MosaicGlobalRestrictionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicRestrictionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicRestrictionKeyDto;
import io.nem.symbol.catapult.builders.MosaicRestrictionTypeDto;
import io.nem.symbol.catapult.builders.RestrictionRuleBuilder;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.restriction.MosaicGlobalRestrictionItem;
import io.nem.symbol.sdk.model.restriction.MosaicRestriction;
import io.nem.symbol.sdk.model.restriction.MosaicRestrictionEntryType;
import java.math.BigInteger;
import java.util.Map;
import java.util.stream.Collectors;

public class MosaicGlobalRestriction
extends MosaicRestriction<MosaicGlobalRestrictionItem> {
    public MosaicGlobalRestriction(String recordId, int version, String compositeHash, MosaicRestrictionEntryType entryType, MosaicId mosaicId, Map<BigInteger, MosaicGlobalRestrictionItem> restrictions) {
        super(recordId, version, compositeHash, entryType, mosaicId, restrictions);
    }

    @Override
    public byte[] serialize() {
        MosaicIdDto mosaicId = SerializationUtils.toMosaicIdDto(this.getMosaicId());
        GlobalKeyValueSetBuilder restrictions = GlobalKeyValueSetBuilder.create(this.getRestrictions().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(this::toGlobalKeyValueSetBuilder).collect(Collectors.toList()));
        MosaicGlobalRestrictionEntryBuilder entry = MosaicGlobalRestrictionEntryBuilder.create((MosaicIdDto)mosaicId, (GlobalKeyValueSetBuilder)restrictions);
        return MosaicRestrictionEntryBuilder.createGlobal((short)((short)this.getVersion()), (MosaicGlobalRestrictionEntryBuilder)entry).serialize();
    }

    private GlobalKeyValueBuilder toGlobalKeyValueSetBuilder(Map.Entry<BigInteger, MosaicGlobalRestrictionItem> entry) {
        MosaicRestrictionKeyDto key = new MosaicRestrictionKeyDto(entry.getKey().longValue());
        MosaicIdDto referenceMosaicId = SerializationUtils.toMosaicIdDto(entry.getValue().getReferenceMosaicId());
        long restrictionValue = entry.getValue().getRestrictionValue().longValue();
        MosaicRestrictionTypeDto restrictionType = MosaicRestrictionTypeDto.rawValueOf((byte)entry.getValue().getRestrictionType().getValue());
        RestrictionRuleBuilder restrictionRule = RestrictionRuleBuilder.create((MosaicIdDto)referenceMosaicId, (long)restrictionValue, (MosaicRestrictionTypeDto)restrictionType);
        return GlobalKeyValueBuilder.create((MosaicRestrictionKeyDto)key, (RestrictionRuleBuilder)restrictionRule);
    }
}

