/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.restriction;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AddressKeyValueBuilder;
import io.nem.symbol.catapult.builders.AddressKeyValueSetBuilder;
import io.nem.symbol.catapult.builders.MosaicAddressRestrictionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicRestrictionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicRestrictionKeyDto;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.restriction.MosaicRestriction;
import io.nem.symbol.sdk.model.restriction.MosaicRestrictionEntryType;
import java.math.BigInteger;
import java.util.Map;
import java.util.stream.Collectors;

public class MosaicAddressRestriction
extends MosaicRestriction<BigInteger> {
    private final Address targetAddress;

    public MosaicAddressRestriction(String recordId, int version, String compositeHash, MosaicRestrictionEntryType entryType, MosaicId mosaicId, Address targetAddress, Map<BigInteger, BigInteger> restrictions) {
        super(recordId, version, compositeHash, entryType, mosaicId, restrictions);
        this.targetAddress = targetAddress;
    }

    public Address getTargetAddress() {
        return this.targetAddress;
    }

    @Override
    public byte[] serialize() {
        MosaicIdDto mosaicId = SerializationUtils.toMosaicIdDto(this.getMosaicId());
        AddressDto targetAddress = SerializationUtils.toAddressDto(this.getTargetAddress());
        AddressKeyValueSetBuilder restrictions = AddressKeyValueSetBuilder.create(this.getRestrictions().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(this::toAddressKeyValueBuilder).collect(Collectors.toList()));
        MosaicAddressRestrictionEntryBuilder entry = MosaicAddressRestrictionEntryBuilder.create((MosaicIdDto)mosaicId, (AddressDto)targetAddress, (AddressKeyValueSetBuilder)restrictions);
        return MosaicRestrictionEntryBuilder.createAddress((short)((short)this.getVersion()), (MosaicAddressRestrictionEntryBuilder)entry).serialize();
    }

    private AddressKeyValueBuilder toAddressKeyValueBuilder(Map.Entry<BigInteger, BigInteger> entry) {
        MosaicRestrictionKeyDto key = new MosaicRestrictionKeyDto(entry.getKey().longValue());
        return AddressKeyValueBuilder.create((MosaicRestrictionKeyDto)key, (long)entry.getValue().longValue());
    }
}

