/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.utils.ArrayUtils;
import io.nem.symbol.core.utils.ByteUtils;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.receipt.Receipt;
import io.nem.symbol.sdk.model.receipt.ReceiptSource;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class TransactionStatement
implements Stored {
    private final Optional<String> recordId;
    private final BigInteger height;
    private final ReceiptSource receiptSource;
    private final List<Receipt> receipts;

    public TransactionStatement(String recordId, BigInteger height, ReceiptSource receiptSource, List<Receipt> receipts) {
        this.recordId = Optional.ofNullable(recordId);
        this.height = height;
        this.receiptSource = receiptSource;
        this.receipts = receipts;
    }

    public ReceiptSource getReceiptSource() {
        return this.receiptSource;
    }

    public BigInteger getHeight() {
        return this.height;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public String generateHash() {
        byte[] versionByte = ByteUtils.shortToBytes(Short.reverseBytes((short)ReceiptVersion.TRANSACTION_STATEMENT.getValue()));
        byte[] typeByte = ByteUtils.shortToBytes(Short.reverseBytes((short)ReceiptType.TRANSACTION_GROUP.getValue()));
        byte[] sourceByte = this.getReceiptSource().serialize();
        byte[] results = ArrayUtils.concat(versionByte, typeByte, sourceByte);
        for (Receipt receipt : this.receipts) {
            results = ArrayUtils.concat(results, receipt.serialize());
        }
        byte[] hash = Hashes.sha3_256(new byte[][]{results});
        return ConvertUtils.toHex(hash);
    }

    @Override
    public Optional<String> getRecordId() {
        return this.recordId;
    }
}

