/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AddressResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.AddressResolutionStatementBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicResolutionStatementBuilder;
import io.nem.symbol.catapult.builders.ReceiptSourceBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import io.nem.symbol.sdk.model.receipt.ResolutionEntry;
import io.nem.symbol.sdk.model.receipt.ResolutionType;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ResolutionStatement<U, R>
implements Stored {
    private final Optional<String> recordId;
    private final ResolutionType resolutionType;
    private final BigInteger height;
    private final U unresolved;
    private final List<ResolutionEntry<R>> resolutionEntries;

    public ResolutionStatement(String recordId, ResolutionType resolutionType, BigInteger height, U unresolved, List<ResolutionEntry<R>> resolutionEntries) {
        this.recordId = Optional.ofNullable(recordId);
        this.height = height;
        this.unresolved = unresolved;
        this.resolutionEntries = resolutionEntries;
        this.resolutionType = resolutionType;
        this.validateType();
    }

    public U getUnresolved() {
        return this.unresolved;
    }

    public BigInteger getHeight() {
        return this.height;
    }

    public List<ResolutionEntry<R>> getResolutionEntries() {
        return this.resolutionEntries;
    }

    public ResolutionType getResolutionType() {
        return this.resolutionType;
    }

    private void validateType() {
        this.validateType(ResolutionType.ADDRESS, UnresolvedAddress.class);
        this.validateType(ResolutionType.MOSAIC, UnresolvedMosaicId.class);
        this.resolutionEntries.forEach(entry -> {
            this.validateType(ResolutionType.ADDRESS, ReceiptType.ADDRESS_ALIAS_RESOLUTION, entry.getType());
            this.validateType(ResolutionType.MOSAIC, ReceiptType.MOSAIC_ALIAS_RESOLUTION, entry.getType());
        });
    }

    private void validateType(ResolutionType givenResolutionType, Class<?> expectedType) {
        if (!expectedType.isAssignableFrom(this.unresolved.getClass()) && this.getResolutionType() == givenResolutionType) {
            throw new IllegalArgumentException("Unresolved Type: [" + expectedType.getName() + "] is not valid for this ResolutionEntry type " + (Object)((Object)this.getResolutionType()));
        }
    }

    private void validateType(ResolutionType givenResolutionType, ReceiptType expectedReceiptType, ReceiptType currentRecipientType) {
        if (this.getResolutionType() == givenResolutionType && currentRecipientType != expectedReceiptType) {
            throw new IllegalArgumentException("Resolution Type: [" + (Object)((Object)this.getResolutionType()) + "] does not match ResolutionEntry's type: [" + (Object)((Object)currentRecipientType) + "] for this ResolutionStatement");
        }
    }

    public Optional<ResolutionEntry<R>> getResolutionEntryById(long primaryId, long secondaryId) {
        long resolvedPrimaryId = this.getMaxAvailablePrimaryId(primaryId);
        if (resolvedPrimaryId == 0L) {
            return Optional.empty();
        }
        if (primaryId > resolvedPrimaryId) {
            return this.resolutionEntries.stream().filter(entry -> entry.getReceiptSource().getPrimaryId() == resolvedPrimaryId && entry.getReceiptSource().getSecondaryId() == this.getMaxSecondaryIdByPrimaryId(resolvedPrimaryId)).findFirst();
        }
        long resolvedSecondaryId = this.getMaxSecondaryIdByPrimaryIdAndSecondaryId(resolvedPrimaryId, secondaryId);
        if (resolvedSecondaryId == 0L && resolvedSecondaryId != secondaryId) {
            long lastPrimaryId = this.getMaxAvailablePrimaryId(resolvedPrimaryId - 1L);
            return this.resolutionEntries.stream().filter(entry -> entry.getReceiptSource().getPrimaryId() == lastPrimaryId && entry.getReceiptSource().getSecondaryId() == this.getMaxSecondaryIdByPrimaryId(lastPrimaryId)).findFirst();
        }
        return this.resolutionEntries.stream().filter(entry -> entry.getReceiptSource().getPrimaryId() == resolvedPrimaryId).filter(entry -> entry.getReceiptSource().getSecondaryId() == resolvedSecondaryId).findFirst();
    }

    private long getMaxSecondaryIdByPrimaryId(long primaryId) {
        return this.resolutionEntries.stream().filter(entry -> entry.getReceiptSource().getPrimaryId() == primaryId).mapToLong(entry -> entry.getReceiptSource().getSecondaryId()).max().orElseThrow(() -> new IllegalArgumentException("resolutionEntries is empty when calculating getMaxSecondaryIdByPrimaryId"));
    }

    private long getMaxSecondaryIdByPrimaryIdAndSecondaryId(long primaryId, long secondaryId) {
        return this.resolutionEntries.stream().filter(entry -> entry.getReceiptSource().getPrimaryId() == primaryId).mapToLong(entry -> secondaryId >= entry.getReceiptSource().getSecondaryId() ? entry.getReceiptSource().getSecondaryId() : 0L).max().orElseThrow(() -> new IllegalArgumentException("resolutionEntries is empty when calculating getMaxSecondaryIdByPrimaryIdAndSecondaryId"));
    }

    private long getMaxAvailablePrimaryId(long primaryId) {
        return this.resolutionEntries.stream().mapToLong(entry -> primaryId >= entry.getReceiptSource().getPrimaryId() ? entry.getReceiptSource().getPrimaryId() : 0L).max().orElseThrow(() -> new IllegalArgumentException("resolutionEntries is empty when calculating getMaxAvailablePrimaryId"));
    }

    public String generateHash(NetworkType networkType) {
        byte[] serialized = this.serialize(networkType);
        byte[] hash = Hashes.sha3_256(new byte[][]{serialized});
        return ConvertUtils.toHex(hash);
    }

    private byte[] serialize(NetworkType networkType) {
        ReceiptType type = this.resolutionType == ResolutionType.ADDRESS ? ReceiptType.ADDRESS_ALIAS_RESOLUTION : ReceiptType.MOSAIC_ALIAS_RESOLUTION;
        ReceiptTypeDto recipientTypeDto = ReceiptTypeDto.rawValueOf((short)((short)type.getValue()));
        short version = (short)ReceiptVersion.RESOLUTION_STATEMENT.getValue();
        MosaicResolutionStatementBuilder serializer = this.resolutionType == ResolutionType.ADDRESS ? AddressResolutionStatementBuilder.create((short)version, (ReceiptTypeDto)recipientTypeDto, (UnresolvedAddressDto)SerializationUtils.toUnresolvedAddress((UnresolvedAddress)this.unresolved, networkType), this.resolutionEntries.stream().map(entry -> AddressResolutionEntryBuilder.create((ReceiptSourceBuilder)ReceiptSourceBuilder.create((int)((int)entry.getReceiptSource().getPrimaryId()), (int)((int)entry.getReceiptSource().getSecondaryId())), (AddressDto)SerializationUtils.toAddressDto((Address)entry.getResolved()))).collect(Collectors.toList())) : MosaicResolutionStatementBuilder.create((short)version, (ReceiptTypeDto)recipientTypeDto, (UnresolvedMosaicIdDto)SerializationUtils.toUnresolvedMosaicIdDto((UnresolvedMosaicId)this.unresolved), this.resolutionEntries.stream().map(entry -> MosaicResolutionEntryBuilder.create((ReceiptSourceBuilder)ReceiptSourceBuilder.create((int)((int)entry.getReceiptSource().getPrimaryId()), (int)((int)entry.getReceiptSource().getSecondaryId())), (MosaicIdDto)SerializationUtils.toMosaicIdDto((MosaicId)entry.getResolved()))).collect(Collectors.toList()));
        return serializer.serialize();
    }

    @Override
    public Optional<String> getRecordId() {
        return this.recordId;
    }
}

