/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AddressResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.ReceiptSourceBuilder;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.receipt.ReceiptSource;
import io.nem.symbol.sdk.model.receipt.ReceiptType;

public class ResolutionEntry<T> {
    private final T resolved;
    private final ReceiptSource receiptSource;
    private final ReceiptType type;

    ResolutionEntry(T resolved, ReceiptSource receiptSource, ReceiptType type) {
        this.receiptSource = receiptSource;
        this.resolved = resolved;
        this.type = type;
        this.validateReceiptType(type);
        this.validateResolvedType();
    }

    public static ResolutionEntry<Address> forAddress(Address resolved, ReceiptSource receiptSource) {
        return new ResolutionEntry<Address>(resolved, receiptSource, ReceiptType.ADDRESS_ALIAS_RESOLUTION);
    }

    public static ResolutionEntry<MosaicId> forMosaicId(MosaicId resolved, ReceiptSource receiptSource) {
        return new ResolutionEntry<MosaicId>(resolved, receiptSource, ReceiptType.MOSAIC_ALIAS_RESOLUTION);
    }

    public T getResolved() {
        return this.resolved;
    }

    public ReceiptType getType() {
        return this.type;
    }

    public ReceiptSource getReceiptSource() {
        return this.receiptSource;
    }

    private void validateReceiptType(ReceiptType type) {
        if (!ReceiptType.RESOLUTION_STATEMENT.contains((Object)type)) {
            throw new IllegalArgumentException("Receipt type: [" + type.name() + "] is not valid.");
        }
    }

    public byte[] serialize() {
        ReceiptSourceBuilder receiptSourceBuilder = ReceiptSourceBuilder.create((int)((int)this.getReceiptSource().getPrimaryId()), (int)((int)this.getReceiptSource().getSecondaryId()));
        Class<?> resolutionClass = this.resolved.getClass();
        if (Address.class.isAssignableFrom(resolutionClass)) {
            AddressDto addressBuilder = new AddressDto(SerializationUtils.fromAddressToByteBuffer((Address)this.getResolved()));
            AddressResolutionEntryBuilder builder = AddressResolutionEntryBuilder.create((ReceiptSourceBuilder)receiptSourceBuilder, (AddressDto)addressBuilder);
            return builder.serialize();
        }
        MosaicIdDto mosaicIdDto = SerializationUtils.toMosaicIdDto((MosaicId)this.getResolved());
        MosaicResolutionEntryBuilder builder = MosaicResolutionEntryBuilder.create((ReceiptSourceBuilder)receiptSourceBuilder, (MosaicIdDto)mosaicIdDto);
        return builder.serialize();
    }

    private void validateResolvedType() {
        this.validateType(ReceiptType.ADDRESS_ALIAS_RESOLUTION, Address.class);
        this.validateType(ReceiptType.MOSAIC_ALIAS_RESOLUTION, MosaicId.class);
    }

    private void validateType(ReceiptType givenRecipientType, Class<?> expectedType) {
        if (!expectedType.isAssignableFrom(this.resolved.getClass()) && this.getType() == givenRecipientType) {
            throw new IllegalArgumentException("Resolved type: [" + expectedType.getName() + "] is not valid for this ResolutionEntry of type [" + (Object)((Object)this.getType()) + "]");
        }
    }
}

