/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum ReceiptType {
    HARVEST_FEE(8515),
    ADDRESS_ALIAS_RESOLUTION(61763),
    MOSAIC_ALIAS_RESOLUTION(62019),
    TRANSACTION_GROUP(57667),
    MOSAIC_RENTAL_FEE(4685),
    NAMESPACE_RENTAL_FEE(4942),
    LOCK_HASH_COMPLETED(8776),
    LOCK_HASH_EXPIRED(9032),
    LOCK_SECRET_EXPIRED(9042),
    LOCK_HASH_CREATED(12616),
    LOCK_SECRET_CREATED(12626),
    LOCK_SECRET_COMPLETED(8786),
    MOSAIC_EXPIRED(16717),
    NAMESPACE_EXPIRED(16718),
    NAMESPACE_DELETED(16974),
    INFLATION(20803);

    public static final Set<ReceiptType> ARTIFACT_EXPIRY;
    public static final Set<ReceiptType> BALANCE_CHANGE;
    public static final Set<ReceiptType> BALANCE_TRANSFER;
    public static final Set<ReceiptType> RESOLUTION_STATEMENT;
    private final int value;

    private ReceiptType(int value) {
        this.value = value;
    }

    public static ReceiptType rawValueOf(int value) {
        return Arrays.stream(ReceiptType.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " is not a valid value"));
    }

    public int getValue() {
        return this.value;
    }

    static {
        ARTIFACT_EXPIRY = Collections.unmodifiableSet(EnumSet.of(MOSAIC_EXPIRED, NAMESPACE_EXPIRED, NAMESPACE_DELETED));
        BALANCE_CHANGE = Collections.unmodifiableSet(EnumSet.of(HARVEST_FEE, new ReceiptType[]{LOCK_HASH_COMPLETED, LOCK_HASH_CREATED, LOCK_HASH_EXPIRED, LOCK_SECRET_COMPLETED, LOCK_SECRET_CREATED, LOCK_SECRET_EXPIRED}));
        BALANCE_TRANSFER = Collections.unmodifiableSet(EnumSet.of(MOSAIC_RENTAL_FEE, NAMESPACE_RENTAL_FEE));
        RESOLUTION_STATEMENT = Collections.unmodifiableSet(EnumSet.of(ADDRESS_ALIAS_RESOLUTION, MOSAIC_ALIAS_RESOLUTION));
    }
}

