/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.receipt.ResolutionEntry;
import io.nem.symbol.sdk.model.receipt.ResolutionStatement;
import io.nem.symbol.sdk.model.receipt.ResolutionType;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class MosaicResolutionStatement
extends ResolutionStatement<UnresolvedMosaicId, MosaicId> {
    public MosaicResolutionStatement(String recordId, BigInteger height, UnresolvedMosaicId unresolved, List<ResolutionEntry<MosaicId>> resolutionEntries) {
        super(recordId, ResolutionType.MOSAIC, height, unresolved, resolutionEntries);
    }

    public static Optional<MosaicId> getResolvedMosaicId(List<MosaicResolutionStatement> statements, BigInteger height, UnresolvedMosaicId mosaicAlias, long primaryId, long secondaryId) {
        if (mosaicAlias instanceof MosaicId) {
            return Optional.of((MosaicId)mosaicAlias);
        }
        return statements.stream().filter(s -> height.equals(s.getHeight())).filter(r -> ((UnresolvedMosaicId)r.getUnresolved()).equals(mosaicAlias)).map(r -> r.getResolutionEntryById(primaryId, secondaryId).map(ResolutionEntry::getResolved)).findFirst().flatMap(Function.identity());
    }
}

