/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.InflationReceiptBuilder;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.receipt.Receipt;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import java.math.BigInteger;
import java.util.Optional;

public class InflationReceipt
extends Receipt {
    private final MosaicId mosaicId;
    private final BigInteger amount;

    public InflationReceipt(MosaicId mosaicId, BigInteger amount, ReceiptType type, ReceiptVersion version, Optional<Integer> size) {
        super(type, version, size);
        this.amount = amount;
        this.mosaicId = mosaicId;
        this.validateReceiptType(type);
    }

    public InflationReceipt(MosaicId mosaicId, BigInteger amount, ReceiptType type, ReceiptVersion version) {
        super(type, version, Optional.empty());
        this.amount = amount;
        this.mosaicId = mosaicId;
        this.validateReceiptType(type);
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public byte[] serialize() {
        short version = (short)this.getVersion().getValue();
        ReceiptTypeDto type = ReceiptTypeDto.rawValueOf((short)((short)this.getType().getValue()));
        MosaicBuilder mosaic = MosaicBuilder.create((MosaicIdDto)new MosaicIdDto(this.getMosaicId().getIdAsLong()), (AmountDto)SerializationUtils.toAmount(this.getAmount()));
        return InflationReceiptBuilder.create((short)version, (ReceiptTypeDto)type, (MosaicBuilder)mosaic).serialize();
    }

    private void validateReceiptType(ReceiptType type) {
        if (type != ReceiptType.INFLATION) {
            throw new IllegalArgumentException("Receipt type: [" + type.name() + "] is not valid.");
        }
    }
}

