/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.BalanceTransferReceiptBuilder;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.namespace.AddressAlias;
import io.nem.symbol.sdk.model.receipt.Receipt;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class BalanceTransferReceipt
extends Receipt {
    private final Address senderAddress;
    private final Address recipientAddress;
    private final MosaicId mosaicId;
    private final BigInteger amount;

    public BalanceTransferReceipt(Address senderAddress, Address recipientAddress, MosaicId mosaicId, BigInteger amount, ReceiptType type, ReceiptVersion version, Optional<Integer> size) {
        super(type, version, size);
        Validate.notNull((Object)senderAddress, (String)"sender must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)recipientAddress, (String)"recipient must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"amount must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)mosaicId, (String)"mosaicId must not be null", (Object[])new Object[0]);
        this.senderAddress = senderAddress;
        this.recipientAddress = recipientAddress;
        this.amount = amount;
        this.mosaicId = mosaicId;
        this.validateRecipientType();
        this.validateReceiptType(type);
    }

    public BalanceTransferReceipt(Address senderAddress, Address recipientAddress, MosaicId mosaicId, BigInteger amount, ReceiptType type, ReceiptVersion version) {
        this(senderAddress, recipientAddress, mosaicId, amount, type, version, Optional.empty());
    }

    public Address getSenderAddress() {
        return this.senderAddress;
    }

    public Address getRecipientAddress() {
        return this.recipientAddress;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public byte[] serialize() {
        short version = (short)this.getVersion().getValue();
        ReceiptTypeDto type = ReceiptTypeDto.rawValueOf((short)((short)this.getType().getValue()));
        MosaicBuilder mosaic = MosaicBuilder.create((MosaicIdDto)new MosaicIdDto(this.getMosaicId().getIdAsLong()), (AmountDto)SerializationUtils.toAmount(this.getAmount()));
        AddressDto senderAddress = SerializationUtils.toAddressDto(this.getSenderAddress());
        AddressDto recipientAddress = SerializationUtils.toAddressDto(this.getRecipientAddress());
        return BalanceTransferReceiptBuilder.create((short)version, (ReceiptTypeDto)type, (MosaicBuilder)mosaic, (AddressDto)senderAddress, (AddressDto)recipientAddress).serialize();
    }

    private void validateReceiptType(ReceiptType type) {
        if (!ReceiptType.BALANCE_TRANSFER.contains((Object)type)) {
            throw new IllegalArgumentException("Receipt type: [" + type.name() + "] is not valid.");
        }
    }

    private void validateRecipientType() {
        Class<?> recipientClass = this.recipientAddress.getClass();
        if (!Address.class.isAssignableFrom(recipientClass) && !AddressAlias.class.isAssignableFrom(recipientClass)) {
            throw new IllegalArgumentException("Recipient type: [" + recipientClass.getName() + "] is not valid for BalanceTransferReceipt");
        }
    }
}

