/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.BalanceChangeReceiptBuilder;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.receipt.Receipt;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import java.math.BigInteger;
import java.util.Optional;

public class BalanceChangeReceipt
extends Receipt {
    private final Address targetAddress;
    private final MosaicId mosaicId;
    private final BigInteger amount;

    public BalanceChangeReceipt(Address targetAddress, MosaicId mosaicId, BigInteger amount, ReceiptType type, ReceiptVersion version, Optional<Integer> size) {
        super(type, version, size);
        this.targetAddress = targetAddress;
        this.amount = amount;
        this.mosaicId = mosaicId;
        this.validateReceiptType(type);
    }

    public BalanceChangeReceipt(Address targetAddress, MosaicId mosaicId, BigInteger amount, ReceiptType type, ReceiptVersion version) {
        this(targetAddress, mosaicId, amount, type, version, Optional.empty());
    }

    public Address getTargetAddress() {
        return this.targetAddress;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public byte[] serialize() {
        short version = (short)this.getVersion().getValue();
        ReceiptTypeDto type = ReceiptTypeDto.rawValueOf((short)((short)this.getType().getValue()));
        MosaicBuilder mosaic = MosaicBuilder.create((MosaicIdDto)new MosaicIdDto(this.getMosaicId().getIdAsLong()), (AmountDto)SerializationUtils.toAmount(this.getAmount()));
        AddressDto targetAddress = SerializationUtils.toAddressDto(this.getTargetAddress());
        return BalanceChangeReceiptBuilder.create((short)version, (ReceiptTypeDto)type, (MosaicBuilder)mosaic, (AddressDto)targetAddress).serialize();
    }

    private void validateReceiptType(ReceiptType type) {
        if (!ReceiptType.BALANCE_CHANGE.contains((Object)type)) {
            throw new IllegalArgumentException("Receipt type: [" + type.name() + "] is not valid.");
        }
    }
}

