/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.catapult.builders.MosaicExpiryReceiptBuilder;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.NamespaceExpiryReceiptBuilder;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.receipt.Receipt;
import io.nem.symbol.sdk.model.receipt.ReceiptType;
import io.nem.symbol.sdk.model.receipt.ReceiptVersion;
import java.math.BigInteger;
import java.util.Optional;

public class ArtifactExpiryReceipt<T>
extends Receipt {
    private final T artifactId;

    public ArtifactExpiryReceipt(T artifactId, ReceiptType type, ReceiptVersion version, Optional<Integer> size) {
        super(type, version, size);
        this.artifactId = artifactId;
        this.validateArtifactType();
        this.validateReceiptType(type);
    }

    public ArtifactExpiryReceipt(T artifactId, ReceiptType type, ReceiptVersion version) {
        super(type, version, Optional.empty());
        this.artifactId = artifactId;
        this.validateArtifactType();
        this.validateReceiptType(type);
    }

    public T getArtifactId() {
        return this.artifactId;
    }

    private void validateArtifactType() {
        Class<?> artifactClass = this.artifactId.getClass();
        if (!MosaicId.class.isAssignableFrom(artifactClass) && !NamespaceId.class.isAssignableFrom(artifactClass)) {
            throw new IllegalArgumentException("Artifact type: [" + artifactClass.getName() + "] is not valid for ArtifactExpiryReceipt");
        }
    }

    @Override
    public byte[] serialize() {
        short version = (short)this.getVersion().getValue();
        ReceiptTypeDto type = ReceiptTypeDto.rawValueOf((short)((short)this.getType().getValue()));
        if (this.artifactId instanceof MosaicId) {
            return MosaicExpiryReceiptBuilder.create((short)version, (ReceiptTypeDto)type, (MosaicIdDto)new MosaicIdDto(this.getArtifactIdValue().longValue())).serialize();
        }
        return NamespaceExpiryReceiptBuilder.create((short)version, (ReceiptTypeDto)type, (NamespaceIdDto)new NamespaceIdDto(this.getArtifactIdValue().longValue())).serialize();
    }

    private void validateReceiptType(ReceiptType type) {
        if (!ReceiptType.ARTIFACT_EXPIRY.contains((Object)type)) {
            throw new IllegalArgumentException("Receipt type: [" + type.name() + "] is not valid.");
        }
    }

    private BigInteger getArtifactIdValue() {
        Class<?> artifactClass = this.artifactId.getClass();
        if (MosaicId.class.isAssignableFrom(artifactClass)) {
            return ((MosaicId)this.artifactId).getId();
        }
        return ((NamespaceId)this.artifactId).getId();
    }
}

