/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.receipt;

import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.receipt.ResolutionEntry;
import io.nem.symbol.sdk.model.receipt.ResolutionStatement;
import io.nem.symbol.sdk.model.receipt.ResolutionType;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class AddressResolutionStatement
extends ResolutionStatement<UnresolvedAddress, Address> {
    public AddressResolutionStatement(String recordId, BigInteger height, UnresolvedAddress unresolved, List<ResolutionEntry<Address>> resolutionEntries) {
        super(recordId, ResolutionType.ADDRESS, height, unresolved, resolutionEntries);
    }

    public static Optional<Address> getResolvedAddress(List<AddressResolutionStatement> statements, BigInteger height, UnresolvedAddress unresolvedAddress, long primaryId, long secondaryId) {
        if (unresolvedAddress instanceof Address) {
            return Optional.of((Address)unresolvedAddress);
        }
        return statements.stream().filter(s -> height.equals(s.getHeight())).filter(r -> ((UnresolvedAddress)r.getUnresolved()).equals(unresolvedAddress)).map(r -> r.getResolutionEntryById(primaryId, secondaryId).map(ResolutionEntry::getResolved)).findFirst().flatMap(Function.identity());
    }
}

