/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Validate;

public enum RoleType {
    PEER_NODE(1),
    API_NODE(2),
    VOTING_NODE(4),
    IP_V4_NODE(64),
    IP_V6_NODE(128);

    private static final int MAX_FLAG_VALUE;
    private final int value;

    private RoleType(int value) {
        this.value = value;
    }

    public static List<RoleType> toList(int flags) {
        Validate.isTrue((flags >= 0 ? 1 : 0) != 0, (String)"flags must be 0 or greater", (Object[])new Object[0]);
        Validate.isTrue((flags <= MAX_FLAG_VALUE ? 1 : 0) != 0, (String)("flags must be " + MAX_FLAG_VALUE + " or smaller"), (Object[])new Object[0]);
        ArrayList<RoleType> roles = new ArrayList<RoleType>();
        int temp = flags;
        int totalValues = RoleType.values().length;
        for (int i = 0; i < totalValues; ++i) {
            RoleType roleType = RoleType.values()[totalValues - i - 1];
            if (temp < roleType.getValue()) continue;
            temp -= roleType.getValue();
            roles.add(0, roleType);
        }
        Validate.isTrue((temp == 0 ? 1 : 0) != 0, (String)"more flags than expected have been provided", (Object[])new Object[0]);
        return roles;
    }

    public int getValue() {
        return this.value;
    }

    static {
        MAX_FLAG_VALUE = Arrays.stream(RoleType.values()).mapToInt(RoleType::getValue).sum();
    }
}

