/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.network;

import java.util.Arrays;

public enum NetworkType {
    MAIN_NET(104, "mainnet", 'N'),
    TEST_NET(152, "testnet", 'T');

    private final int value;
    private final String networkName;
    private final char addressPrefix;

    private NetworkType(int value, String networkName, char addressPrefix) {
        this.value = value;
        this.networkName = networkName;
        this.addressPrefix = addressPrefix;
    }

    public static NetworkType rawValueOf(int value) {
        return Arrays.stream(NetworkType.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(value + " is not a valid value"));
    }

    public static NetworkType rawValueOf(String networkName) {
        return Arrays.stream(NetworkType.values()).filter(e -> e.getNetworkName().equals(networkName)).findFirst().orElseThrow(() -> new IllegalArgumentException(networkName + " is not a valid network name"));
    }

    public int getValue() {
        return this.value;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public char getAddressPrefix() {
        return this.addressPrefix;
    }
}

