/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.namespace;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.NamespaceAliasBuilder;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceLifetimeBuilder;
import io.nem.symbol.catapult.builders.NamespacePathBuilder;
import io.nem.symbol.catapult.builders.RootNamespaceHistoryBuilder;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.namespace.Alias;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceRegistrationType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class NamespaceInfo
implements Stored {
    private final String recordId;
    private final int version;
    private final boolean active;
    private final Integer index;
    private final NamespaceRegistrationType registrationType;
    private final Integer depth;
    private final List<NamespaceId> levels;
    private final NamespaceId parentId;
    private final Address ownerAddress;
    private final BigInteger startHeight;
    private final BigInteger endHeight;
    private final Alias<?> alias;

    public NamespaceInfo(String recordId, int version, boolean active, Integer index, NamespaceRegistrationType registrationType, Integer depth, List<NamespaceId> levels, NamespaceId parentId, Address ownerAddress, BigInteger startHeight, BigInteger endHeight, Alias<?> alias) {
        Validate.notNull((Object)index, (String)"index is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)registrationType), (String)"registrationType is required", (Object[])new Object[0]);
        Validate.notNull((Object)depth, (String)"depth is required", (Object[])new Object[0]);
        Validate.notNull((Object)ownerAddress, (String)"ownerAddress is required", (Object[])new Object[0]);
        Validate.notNull((Object)startHeight, (String)"startHeight is required", (Object[])new Object[0]);
        Validate.notNull((Object)endHeight, (String)"endHeight is required", (Object[])new Object[0]);
        Validate.notNull(alias, (String)"alias is required", (Object[])new Object[0]);
        this.recordId = recordId;
        this.version = version;
        this.active = active;
        this.index = index;
        this.registrationType = registrationType;
        this.depth = depth;
        this.levels = levels;
        this.parentId = parentId;
        this.ownerAddress = ownerAddress;
        this.startHeight = startHeight;
        this.endHeight = endHeight;
        this.alias = alias;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isExpired() {
        return !this.active;
    }

    public Integer getIndex() {
        return this.index;
    }

    public NamespaceRegistrationType getRegistrationType() {
        return this.registrationType;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public List<NamespaceId> getLevels() {
        return this.levels;
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public BigInteger getStartHeight() {
        return this.startHeight;
    }

    public BigInteger getEndHeight() {
        return this.endHeight;
    }

    public NamespaceId getId() {
        return this.levels.get(this.levels.size() - 1);
    }

    public boolean isRoot() {
        return this.registrationType == NamespaceRegistrationType.ROOT_NAMESPACE;
    }

    public Alias<?> getAlias() {
        return this.alias;
    }

    public boolean hasAlias() {
        return !this.alias.isEmpty();
    }

    public boolean isSubnamespace() {
        return this.registrationType == NamespaceRegistrationType.SUB_NAMESPACE;
    }

    public int getVersion() {
        return this.version;
    }

    public NamespaceId parentNamespaceId() {
        if (this.isRoot()) {
            throw new IllegalStateException("Is A Root Namespace");
        }
        return this.parentId;
    }

    public byte[] serialize(List<NamespaceInfo> fullPath) {
        if (!this.isRoot()) {
            throw new IllegalArgumentException("Namespace must be root in order to serialize!");
        }
        List<NamespaceInfo> children = NamespaceInfo.sortList(fullPath, this.getId());
        if (fullPath.size() != children.size()) {
            throw new IllegalArgumentException("Some of the children do not belong to this root namespace");
        }
        NamespaceIdDto id = new NamespaceIdDto(this.getId().getIdAsLong());
        AddressDto ownerAddress = SerializationUtils.toAddressDto(this.getOwnerAddress());
        NamespaceLifetimeBuilder lifetime = NamespaceLifetimeBuilder.create((HeightDto)new HeightDto(this.getStartHeight().longValue()), (HeightDto)new HeightDto(this.getEndHeight().longValue()));
        NamespaceAliasBuilder rootAlias = this.getAlias().createAliasBuilder();
        List paths = children.stream().map(this::toNamespaceAliasTypeDto).collect(Collectors.toList());
        RootNamespaceHistoryBuilder builder = RootNamespaceHistoryBuilder.create((short)((short)this.getVersion()), (NamespaceIdDto)id, (AddressDto)ownerAddress, (NamespaceLifetimeBuilder)lifetime, (NamespaceAliasBuilder)rootAlias, paths);
        return builder.serialize();
    }

    private static List<NamespaceInfo> sortList(List<NamespaceInfo> nodes, NamespaceId parentId) {
        return NamespaceInfo.treeAdd(nodes, parentId, new ArrayList<NamespaceInfo>());
    }

    private static List<NamespaceInfo> treeAdd(List<NamespaceInfo> nodes, NamespaceId parentId, List<NamespaceInfo> treeList) {
        nodes.stream().filter(r -> r.isSubnamespace() && r.parentNamespaceId().equals(parentId)).sorted(Comparator.comparing(n -> n.getId().getId())).forEach(n -> {
            treeList.add((NamespaceInfo)n);
            NamespaceInfo.treeAdd(nodes, n.getId(), treeList);
        });
        return treeList;
    }

    private NamespacePathBuilder toNamespaceAliasTypeDto(NamespaceInfo namespaceInfo) {
        List path = namespaceInfo.getLevels().stream().skip(1L).map(id -> new NamespaceIdDto(id.getIdAsLong())).collect(Collectors.toList());
        NamespaceAliasBuilder alias = namespaceInfo.getAlias().createAliasBuilder();
        return NamespacePathBuilder.create(path, (NamespaceAliasBuilder)alias);
    }
}

