/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.namespace;

import io.nem.symbol.core.utils.ByteUtils;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.IdGenerator;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NamespaceId
implements UnresolvedMosaicId,
UnresolvedAddress {
    private final BigInteger id;
    private final Optional<String> fullName;

    public NamespaceId(String hex) {
        ConvertUtils.validateIsHexString(hex, 16);
        this.id = new BigInteger(hex, 16);
        this.fullName = Optional.empty();
    }

    private NamespaceId(BigInteger id, Optional<String> fullName) {
        this.id = ConvertUtils.toUnsignedBigInteger(id);
        this.fullName = fullName;
    }

    public static NamespaceId createFromName(String namespaceName) {
        return new NamespaceId(IdGenerator.generateNamespaceId(namespaceName), Optional.of(namespaceName));
    }

    public static NamespaceId createFromIdAndFullName(BigInteger id, String fullName) {
        return new NamespaceId(id, Optional.of(fullName));
    }

    public static NamespaceId createFromNameAndParentId(String namespaceName, BigInteger parentId) {
        return new NamespaceId(IdGenerator.generateNamespaceId(namespaceName, parentId), Optional.of(namespaceName));
    }

    public static NamespaceId createFromNameAndParentName(String namespaceName, String parentNamespaceName) {
        return new NamespaceId(IdGenerator.generateNamespaceId(namespaceName, parentNamespaceName), Optional.of(parentNamespaceName + "." + namespaceName));
    }

    public static NamespaceId createFromId(BigInteger id) {
        return new NamespaceId(id, Optional.empty());
    }

    public static List<BigInteger> getNamespacePath(String namespaceName) {
        return IdGenerator.generateNamespacePath(namespaceName);
    }

    @Override
    public BigInteger getId() {
        return this.id;
    }

    @Override
    public long getIdAsLong() {
        return this.id.longValue();
    }

    public Optional<String> getFullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceId that = (NamespaceId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String encoded(NetworkType networkType) {
        return ConvertUtils.toHex(SerializationUtils.fromUnresolvedAddressToByteBuffer(this, networkType).array());
    }

    @Override
    public String plain() {
        return this.getIdAsHex();
    }

    @Override
    public String getIdAsHex() {
        return ConvertUtils.toHex(ByteUtils.bigIntToBytes(this.getId()));
    }
}

