/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

import io.nem.symbol.sdk.infrastructure.RandomUtils;
import java.math.BigInteger;
import java.util.Objects;

public class MosaicNonce {
    private final int nonce;

    public MosaicNonce(int nonce) {
        this.nonce = nonce;
    }

    public static MosaicNonce createRandom() {
        return new MosaicNonce(RandomUtils.generateRandomInt());
    }

    public static MosaicNonce createFromBigInteger(BigInteger number) {
        return new MosaicNonce(number.intValue());
    }

    public static MosaicNonce createFromInteger(Integer number) {
        return new MosaicNonce(number);
    }

    public int getNonceAsInt() {
        return this.nonce;
    }

    public long getNonceAsLong() {
        return Integer.toUnsignedLong(this.getNonceAsInt());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicNonce that = (MosaicNonce)o;
        return this.nonce == that.nonce;
    }

    public int hashCode() {
        return Objects.hash(this.nonce);
    }
}

