/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.MosaicDefinitionBuilder;
import io.nem.symbol.catapult.builders.MosaicEntryBuilder;
import io.nem.symbol.catapult.builders.MosaicFlagsDto;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.MosaicPropertiesBuilder;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.Currency;
import io.nem.symbol.sdk.model.mosaic.CurrencyBuilder;
import io.nem.symbol.sdk.model.mosaic.MosaicFlags;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class MosaicInfo
implements Stored {
    private final String recordId;
    private final int version;
    private final MosaicId mosaicId;
    private final BigInteger supply;
    private final BigInteger startHeight;
    private final Address ownerAddress;
    private final long revision;
    private final MosaicFlags mosaicFlags;
    private final int divisibility;
    private final BigInteger duration;

    public MosaicInfo(String recordId, int version, MosaicId mosaicId, BigInteger supply, BigInteger startHeight, Address ownerAddress, long revision, MosaicFlags mosaicFlags, int divisibility, BigInteger duration) {
        Validate.notNull((Object)mosaicId, (String)"mosaicId must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)supply, (String)"supply must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)startHeight, (String)"startHeight must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)ownerAddress, (String)"ownerAddress must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)mosaicFlags, (String)"mosaicFlags must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)duration, (String)"duration must be provided", (Object[])new Object[0]);
        this.recordId = recordId;
        this.version = version;
        this.mosaicId = mosaicId;
        this.supply = supply;
        this.startHeight = startHeight;
        this.ownerAddress = ownerAddress;
        this.revision = revision;
        this.mosaicFlags = mosaicFlags;
        this.divisibility = divisibility;
        this.duration = duration;
    }

    public MosaicId getMosaicId() {
        return this.mosaicId;
    }

    public BigInteger getSupply() {
        return this.supply;
    }

    public BigInteger getStartHeight() {
        return this.startHeight;
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public long getRevision() {
        return this.revision;
    }

    public boolean isSupplyMutable() {
        return this.mosaicFlags.isSupplyMutable();
    }

    public boolean isTransferable() {
        return this.mosaicFlags.isTransferable();
    }

    public boolean isRestrictable() {
        return this.mosaicFlags.isRestrictable();
    }

    public boolean isRevokable() {
        return this.mosaicFlags.isRevokable();
    }

    public int getDivisibility() {
        return this.divisibility;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public int getVersion() {
        return this.version;
    }

    public MosaicFlags getMosaicFlags() {
        return this.mosaicFlags;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public Currency toCurrency() {
        return new CurrencyBuilder(this.getMosaicId(), this.getDivisibility()).withTransferable(this.isTransferable()).withSupplyMutable(this.isSupplyMutable()).withRestrictable(this.isRestrictable()).withRevokable(this.isRevokable()).build();
    }

    public byte[] serialize() {
        MosaicIdDto mosaicId = SerializationUtils.toMosaicIdDto(this.getMosaicId());
        AmountDto supply = SerializationUtils.toAmount(this.getSupply());
        HeightDto startHeight = new HeightDto(this.getStartHeight().longValue());
        AddressDto ownerAddress = SerializationUtils.toAddressDto(this.getOwnerAddress());
        int revision = (int)this.getRevision();
        EnumSet<MosaicFlagsDto> flags = SerializationUtils.getMosaicFlagsEnumSet(this.getMosaicFlags());
        MosaicPropertiesBuilder properties = MosaicPropertiesBuilder.create(flags, (byte)((byte)this.getDivisibility()), (BlockDurationDto)new BlockDurationDto(this.getDuration().longValue()));
        MosaicDefinitionBuilder definition = MosaicDefinitionBuilder.create((HeightDto)startHeight, (AddressDto)ownerAddress, (int)revision, (MosaicPropertiesBuilder)properties);
        return MosaicEntryBuilder.create((short)((short)this.getVersion()), (MosaicIdDto)mosaicId, (AmountDto)supply, (MosaicDefinitionBuilder)definition).serialize();
    }
}

