/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

import io.nem.symbol.core.utils.Base32Encoder;
import io.nem.symbol.core.utils.ByteUtils;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.mosaic.MosaicNonce;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.transaction.IdGenerator;
import java.math.BigInteger;
import java.util.Objects;

public class MosaicId
implements UnresolvedMosaicId {
    private final BigInteger id;

    public MosaicId(String hex) {
        ConvertUtils.validateIsHexString(hex, 16);
        this.id = new BigInteger(hex, 16);
    }

    public MosaicId(BigInteger id) {
        this.id = id;
    }

    public MosaicId(MosaicNonce mosaicNonce, Address owner) {
        this.id = IdGenerator.generateMosaicId(mosaicNonce.getNonceAsInt(), Base32Encoder.getBytes(owner.plain()));
    }

    public MosaicId(MosaicNonce mosaicNonce, PublicAccount owner) {
        this(mosaicNonce, owner.getAddress());
    }

    public static MosaicId createFromNonce(MosaicNonce mosaicNonce, Address owner) {
        return new MosaicId(mosaicNonce, owner);
    }

    public static MosaicId createFromNonce(MosaicNonce mosaicNonce, PublicAccount owner) {
        return new MosaicId(mosaicNonce, owner);
    }

    @Override
    public BigInteger getId() {
        return this.id;
    }

    @Override
    public long getIdAsLong() {
        return this.id.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicId mosaicId = (MosaicId)o;
        return Objects.equals(this.id, mosaicId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String getIdAsHex() {
        byte[] bytes = ByteUtils.bigIntToBytes(this.getId());
        return ConvertUtils.toHex(bytes);
    }
}

