/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

public class MosaicFlags {
    private final boolean supplyMutable;
    private final boolean transferable;
    private final boolean restrictable;
    private final boolean revokable;

    private MosaicFlags(boolean supplyMutable, boolean transferable, boolean restrictable, boolean revokable) {
        this.supplyMutable = supplyMutable;
        this.transferable = transferable;
        this.restrictable = restrictable;
        this.revokable = revokable;
    }

    public static MosaicFlags create(int flags) {
        String flagsString = "000" + Integer.toBinaryString(flags);
        String bitMapFlags = flagsString.substring(flagsString.length() - 4);
        return MosaicFlags.create(bitMapFlags.charAt(3) == '1', bitMapFlags.charAt(2) == '1', bitMapFlags.charAt(1) == '1', bitMapFlags.charAt(0) == '1');
    }

    public static MosaicFlags create(boolean supplyMutable, boolean transferable, boolean restrictable, boolean revokable) {
        return new MosaicFlags(supplyMutable, transferable, restrictable, revokable);
    }

    public static MosaicFlags create(boolean supplyMutable, boolean transferable) {
        return new MosaicFlags(supplyMutable, transferable, false, false);
    }

    public boolean isSupplyMutable() {
        return this.supplyMutable;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public boolean isRestrictable() {
        return this.restrictable;
    }

    public boolean isRevokable() {
        return this.revokable;
    }

    public int getValue() {
        return (this.supplyMutable ? 1 : 0) + (this.transferable ? 2 : 0) + (this.restrictable ? 4 : 0) + (this.revokable ? 8 : 0);
    }
}

