/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class Mosaic {
    private final UnresolvedMosaicId id;
    private final BigInteger amount;

    public Mosaic(UnresolvedMosaicId id, BigInteger amount) {
        Validate.notNull((Object)id, (String)"Id must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)amount, (String)"Amount must not be null", (Object[])new Object[0]);
        ConvertUtils.validateNotNegative(amount);
        this.id = id;
        this.amount = amount;
    }

    public UnresolvedMosaicId getId() {
        return this.id;
    }

    public String getIdAsHex() {
        return this.id.getIdAsHex();
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mosaic mosaic = (Mosaic)o;
        return Objects.equals(this.id, mosaic.id) && Objects.equals(this.amount, mosaic.amount);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amount);
    }
}

