/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

import io.nem.symbol.sdk.model.mosaic.Currency;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public final class CurrencyBuilder {
    private final UnresolvedMosaicId unresolvedMosaicId;
    private final int divisibility;
    private Optional<MosaicId> mosaicId = Optional.empty();
    private Optional<NamespaceId> namespaceId = Optional.empty();
    private boolean transferable = true;
    private boolean supplyMutable = false;
    private boolean restrictable = false;
    private boolean revokable = false;

    public CurrencyBuilder(UnresolvedMosaicId unresolvedMosaicId, int divisibility) {
        Validate.notNull((Object)unresolvedMosaicId, (String)"unresolvedMosaicId must not be null", (Object[])new Object[0]);
        Validate.isTrue((divisibility > 0 ? 1 : 0) != 0, (String)"divisibility must be greater than 0", (Object[])new Object[0]);
        this.unresolvedMosaicId = unresolvedMosaicId;
        this.divisibility = divisibility;
        if (unresolvedMosaicId instanceof NamespaceId) {
            this.withNamespaceId((NamespaceId)unresolvedMosaicId);
        } else {
            this.withMosaicId((MosaicId)unresolvedMosaicId);
        }
    }

    public CurrencyBuilder withMosaicId(MosaicId mosaicId) {
        Validate.notNull((Object)mosaicId, (String)"mosaicId must not be null", (Object[])new Object[0]);
        this.mosaicId = Optional.of(mosaicId);
        return this;
    }

    public CurrencyBuilder withNamespaceId(NamespaceId namespaceId) {
        Validate.notNull((Object)namespaceId, (String)"namespaceId must not be null", (Object[])new Object[0]);
        this.namespaceId = Optional.of(namespaceId);
        return this;
    }

    public CurrencyBuilder withTransferable(boolean transferable) {
        this.transferable = transferable;
        return this;
    }

    public CurrencyBuilder withSupplyMutable(boolean supplyMutable) {
        this.supplyMutable = supplyMutable;
        return this;
    }

    public CurrencyBuilder withRestrictable(boolean restrictable) {
        this.restrictable = restrictable;
        return this;
    }

    public CurrencyBuilder withRevokable(boolean revokable) {
        this.revokable = revokable;
        return this;
    }

    public Currency build() {
        return new Currency(this);
    }

    public UnresolvedMosaicId getUnresolvedMosaicId() {
        return this.unresolvedMosaicId;
    }

    public int getDivisibility() {
        return this.divisibility;
    }

    public Optional<MosaicId> getMosaicId() {
        return this.mosaicId;
    }

    public Optional<NamespaceId> getNamespaceId() {
        return this.namespaceId;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public boolean isSupplyMutable() {
        return this.supplyMutable;
    }

    public boolean isRestrictable() {
        return this.restrictable;
    }

    public boolean isRevokable() {
        return this.revokable;
    }
}

