/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.mosaic;

import io.nem.symbol.sdk.model.mosaic.CurrencyBuilder;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class Currency {
    public static final Currency SYMBOL_XYM = new CurrencyBuilder(NamespaceId.createFromName("symbol.xym"), 6).withSupplyMutable(false).withTransferable(true).withRestrictable(false).withRevokable(false).build();
    public static final Currency CAT_CURRENCY = new CurrencyBuilder(NamespaceId.createFromName("cat.currency"), 6).withSupplyMutable(false).withTransferable(true).withRestrictable(false).withRevokable(false).build();
    public static final Currency CAT_HARVEST = new CurrencyBuilder(NamespaceId.createFromName("cat.harvest"), 3).withSupplyMutable(true).withTransferable(true).withRestrictable(false).withRevokable(false).build();
    private final UnresolvedMosaicId unresolvedMosaicId;
    private final Optional<MosaicId> mosaicId;
    private final Optional<NamespaceId> namespaceId;
    private final int divisibility;
    private final boolean transferable;
    private final boolean supplyMutable;
    private final boolean restrictable;
    private final boolean revokable;

    Currency(CurrencyBuilder builder) {
        Validate.notNull((Object)builder, (String)"builder must not be null", (Object[])new Object[0]);
        this.unresolvedMosaicId = builder.getUnresolvedMosaicId();
        this.mosaicId = builder.getMosaicId();
        this.namespaceId = builder.getNamespaceId();
        this.divisibility = builder.getDivisibility();
        this.transferable = builder.isTransferable();
        this.supplyMutable = builder.isSupplyMutable();
        this.restrictable = builder.isRestrictable();
        this.revokable = builder.isRevokable();
    }

    public UnresolvedMosaicId getUnresolvedMosaicId() {
        return this.unresolvedMosaicId;
    }

    public Optional<MosaicId> getMosaicId() {
        return this.mosaicId;
    }

    public Optional<NamespaceId> getNamespaceId() {
        return this.namespaceId;
    }

    public int getDivisibility() {
        return this.divisibility;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public boolean isSupplyMutable() {
        return this.supplyMutable;
    }

    public boolean isRestrictable() {
        return this.restrictable;
    }

    public boolean isRevokable() {
        return this.revokable;
    }

    public Mosaic createRelative(double amount) {
        return this.createRelative(BigDecimal.valueOf(amount));
    }

    public Mosaic createRelative(long amount) {
        return this.createRelative(BigInteger.valueOf(amount));
    }

    public Mosaic createRelative(BigDecimal amount) {
        BigInteger relativeAmount = BigDecimal.valueOf(Math.pow(10.0, this.getDivisibility())).multiply(amount).toBigInteger();
        return new Mosaic(this.getUnresolvedMosaicId(), relativeAmount);
    }

    public Mosaic createRelative(BigInteger amount) {
        BigInteger relativeAmount = BigDecimal.valueOf(Math.pow(10.0, this.getDivisibility())).toBigInteger().multiply(amount);
        return new Mosaic(this.getUnresolvedMosaicId(), relativeAmount);
    }

    public Mosaic createAbsolute(BigInteger amount) {
        return new Mosaic(this.getUnresolvedMosaicId(), amount);
    }

    public Mosaic createAbsolute(long amount) {
        return this.createAbsolute(BigInteger.valueOf(amount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Currency currency = (Currency)o;
        return this.divisibility == currency.divisibility && this.transferable == currency.transferable && this.supplyMutable == currency.supplyMutable && this.restrictable == currency.restrictable && this.revokable == currency.revokable && Objects.equals(this.unresolvedMosaicId, currency.unresolvedMosaicId) && Objects.equals(this.mosaicId, currency.mosaicId) && Objects.equals(this.namespaceId, currency.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.unresolvedMosaicId, this.mosaicId, this.namespaceId, this.divisibility, this.transferable, this.supplyMutable, this.restrictable, this.revokable);
    }
}

