/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.metadata;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.MetadataEntryBuilder;
import io.nem.symbol.catapult.builders.MetadataTypeDto;
import io.nem.symbol.catapult.builders.MetadataValueBuilder;
import io.nem.symbol.catapult.builders.ScopedMetadataKeyDto;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.metadata.MetadataType;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class Metadata
implements Stored {
    private final int version;
    private final String recordId;
    private final String compositeHash;
    private final Address sourceAddress;
    private final Address targetAddress;
    private final BigInteger scopedMetadataKey;
    private final MetadataType metadataType;
    private final byte[] value;
    private final Object targetId;

    public Metadata(String recordId, int version, String compositeHash, Address sourceAddress, Address targetAddress, BigInteger scopedMetadataKey, MetadataType metadataType, byte[] value, String targetId) {
        this.recordId = recordId;
        this.version = version;
        this.compositeHash = compositeHash;
        Validate.notNull((Object)sourceAddress, (String)"sourceAddress is required", (Object[])new Object[0]);
        Validate.notNull((Object)targetAddress, (String)"targetAddress is required", (Object[])new Object[0]);
        Validate.notNull((Object)scopedMetadataKey, (String)"scopedMetadataKey is required", (Object[])new Object[0]);
        Validate.notNull((Object)scopedMetadataKey, (String)"scopedMetadataKey is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)metadataType), (String)"metadataType is required", (Object[])new Object[0]);
        this.sourceAddress = sourceAddress;
        this.targetAddress = targetAddress;
        this.scopedMetadataKey = scopedMetadataKey;
        this.metadataType = metadataType;
        this.value = value;
        this.targetId = this.resolveTargetId(targetId, metadataType);
    }

    private Object resolveTargetId(String targetId, MetadataType metadataType) {
        if (metadataType == MetadataType.ACCOUNT) {
            return null;
        }
        Validate.notNull((Object)targetId, (String)("targetId is required when metadata type is  " + (Object)((Object)metadataType)), (Object[])new Object[0]);
        if (metadataType == MetadataType.NAMESPACE) {
            return MapperUtils.toNamespaceId(targetId);
        }
        if (metadataType == MetadataType.MOSAIC) {
            return MapperUtils.toMosaicId(targetId);
        }
        throw new IllegalArgumentException("Invalid metadata type " + (Object)((Object)metadataType));
    }

    public String getCompositeHash() {
        return this.compositeHash;
    }

    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public Address getTargetAddress() {
        return this.targetAddress;
    }

    public BigInteger getScopedMetadataKey() {
        return this.scopedMetadataKey;
    }

    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Optional<Object> getTargetId() {
        return Optional.ofNullable(this.targetId);
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] serialize() {
        AddressDto sourceAddress = SerializationUtils.toAddressDto(this.getSourceAddress());
        AddressDto targetAddress = SerializationUtils.toAddressDto(this.getTargetAddress());
        ScopedMetadataKeyDto scopedMetadataKey = new ScopedMetadataKeyDto(this.getScopedMetadataKey().longValue());
        long targetId = this.getTargetId().map(this::toTargetId).orElse(0L);
        MetadataTypeDto metadataType = MetadataTypeDto.rawValueOf((byte)((byte)this.getMetadataType().getValue()));
        MetadataValueBuilder value = Metadata.toMetadataValueBuilder(this.getValue());
        return MetadataEntryBuilder.create((short)((short)this.getVersion()), (AddressDto)sourceAddress, (AddressDto)targetAddress, (ScopedMetadataKeyDto)scopedMetadataKey, (long)targetId, (MetadataTypeDto)metadataType, (MetadataValueBuilder)value).serialize();
    }

    public static MetadataValueBuilder toMetadataValueBuilder(byte[] value) {
        ByteBuffer rawValue = ByteBuffer.wrap(value);
        return MetadataValueBuilder.create((ByteBuffer)rawValue);
    }

    private Long toTargetId(Object o) {
        if (o instanceof MosaicId) {
            return ((MosaicId)o).getIdAsLong();
        }
        if (o instanceof NamespaceId) {
            return ((NamespaceId)o).getIdAsLong();
        }
        return 0L;
    }
}

